/**
 * WordPress dependencies
 */
import {getBlockType, registerBlockType} from '@wordpress/blocks'
import {applyFilters} from '@wordpress/hooks'

const registerBlock = (name, settings = {}) => {
    const blockCategory = 'woofunnels' // common category for all blocks

    if (getBlockType(name)) {
        return
    }

    const blockName = name.replace(/^\w+\//g, '')
    const blockSettings = {
        ...settings,
        category: blockCategory,
        icon: settings.icon || 'block-default',
        edit: settings.edit || function () {
            return null
        },
        supports: {...settings.supports, ...{reusable: false}} // temporary disable reusable blocks
    }

    // Allow modules to modify the block's attributes.
    blockSettings.attributes = applyFilters(`bwf.block.attributes`, blockSettings.attributes) // global-attributes.js common attributes added in all blocks
    blockSettings.attributes = applyFilters(`bwf.${blockName}.attributes`, blockSettings.attributes)

    // Register the block.
    registerBlockType(name, applyFilters(`bwf.${blockName}.settings`, blockSettings))

    return blockSettings
}

export default registerBlock
