export const SVGBlob1 = () => {
    return (
        <svg
            version="1.1"
            id="Layer_1"
            xmlns="http://www.w3.org/2000/svg"
            x="0px"
            y="0px"
            viewBox="0 0 200 200"
            style="enable-background:new 0 0 200 200;"
            xmlSpace="preserve"
        >
            <path
                d="M188.5,31.9c12.9,15.9,12.5,43.3,10.3,77.1s-6.2,74.2-26.2,86.5s-56.1-3.3-89.4-21.2s-63.7-38.1-76.4-69.8
            C-5.9,73-0.8,29.9,21.6,11.7C44-6.4,83.8,0.5,116.7,6.1S175.7,16.1,188.5,31.9z"
            />
        </svg>
    );
};

export const SVGCircle = () => {
    return (
        <svg
            version="1.1"
            id="Layer_1"
            xmlns="http://www.w3.org/2000/svg"
            x="0px"
            y="0px"
            viewBox="0 0 100 100"
            style="enable-background:new 0 0 100 100;"
            xmlSpace="preserve"
        >
            <circle cx="50" cy="50" r="50"/>
        </svg>
    );
};

export const SVGSquare = () => {
    return (
        <svg
            version="1.1"
            id="Layer_1"
            xmlns="http://www.w3.org/2000/svg"
            x="0px"
            y="0px"
            viewBox="0 0 200 200"
            style="enable-background:new 0 0 200 200;"
            xmlSpace="preserve"
        >
            <rect className="st0" width="200" height="200"/>
        </svg>
    );
};
export const BlockIcon = () => {
    return (
        <svg
            data-prefix="far"
            data-icon="check-circle"
            role="img"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 512 512"
        >
            <path
                fill="currentColor"
                d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"
            ></path>
        </svg>
    );
};

export const IconReset = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="#000000"
            viewBox="0 0 24 24"
            width="12px"
            height="12px"
        >
            <path d="M 12 2 C 6.486 2 2 6.486 2 12 C 2 17.514 6.486 22 12 22 C 17.514 22 22 17.514 22 12 L 20 12 C 20 16.411 16.411 20 12 20 C 7.589 20 4 16.411 4 12 C 4 7.589 7.589 4 12 4 C 14.205991 4 16.202724 4.9004767 17.650391 6.3496094 L 15 9 L 22 9 L 22 2 L 19.060547 4.9394531 C 17.251786 3.1262684 14.757292 2 12 2 z"/>
        </svg>
    );
};

export const IconIndivisual = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            width="24px"
            height="24px"
        >
            <path d="M18 12c0 .5-.1 1.1-.2 1.5l1.6 1.6c.4-1 .6-2 .6-3.1s-.2-2.2-.6-3.1l-1.6 1.6C17.9 10.9 18 11.5 18 12zM10.5 6.2C10.9 6.1 11.5 6 12 6s1.1.1 1.5.2l1.6-1.6c-1-.4-2-.6-3.1-.6S9.8 4.2 8.9 4.6L10.5 6.2zM6 12c0-.5.1-1.1.2-1.5L4.6 8.9C4.2 9.8 4 10.9 4 12s.2 2.2.6 3.1l1.6-1.6C6.1 13.1 6 12.5 6 12zM13.5 17.8c-.5.1-1 .2-1.5.2s-1.1-.1-1.5-.2l-1.6 1.6c1 .4 2 .6 3.1.6s2.2-.2 3.1-.6L13.5 17.8zM21 3L16.8 3 21 7.2zM3 3L3 7.2 7.2 3zM3 21L7.2 21 3 16.8zM21 21L21 16.8 16.8 21z"/>
            <path
                d="M14 5.5H21.1V7.5H14z"
                transform="rotate(-45.001 17.5 6.5)"
            />
            <path
                d="M5.5 3H7.5V10.1H5.5z"
                transform="rotate(-45.001 6.5 6.5)"
            />
            <path
                d="M3 16.5H10.1V18.5H3z"
                transform="rotate(-45.001 6.5 17.5)"
            />
            <path
                d="M16.5 14H18.5V21.1H16.5z"
                transform="rotate(-45.001 17.5 17.5)"
            />
        </svg>
    );
};

export const IconSquare = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="#000000"
            viewBox="0 0 48 48"
            width="24px"
            height="24px"
        >
            <path d="M 6 8 A 2.0002 2.0002 0 0 0 4 10 L 4 38 A 2.0002 2.0002 0 0 0 6 40 L 42 40 A 2.0002 2.0002 0 0 0 44 38 L 44 10 A 2.0002 2.0002 0 0 0 42 8 L 6 8 z M 8 12 L 40 12 L 40 36 L 8 36 L 8 12 z"/>
        </svg>
    );
};

export const CustomDetailsSVG = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="#000000"
            viewBox="0 0 50 50"
            width="50px"
            height="50px"
        >
            <path d="M 3 7 C 1.355469 7 0 8.355469 0 10 L 0 43 C 0 44.644531 1.355469 46 3 46 L 10 46 C 10.550781 46 11 45.550781 11 45 L 11 43.5 C 11 43.195313 10.863281 42.910156 10.625 42.71875 C 10.210938 42.371094 10 41.964844 10 41.5 C 10 40.625 10.625 40 11.5 40 C 12.375 40 13 40.625 13 41.5 C 13 41.964844 12.789063 42.371094 12.375 42.71875 C 12.136719 42.910156 12 43.195313 12 43.5 L 12 45 C 12 45.550781 12.449219 46 13 46 L 37 46 C 37.550781 46 38 45.550781 38 45 L 38 43.5 C 38 43.195313 37.863281 42.910156 37.625 42.71875 C 37.210938 42.371094 37 41.964844 37 41.5 C 37 40.625 37.625 40 38.5 40 C 39.375 40 40 40.625 40 41.5 C 40 41.964844 39.789063 42.371094 39.375 42.71875 C 39.136719 42.910156 39 43.195313 39 43.5 L 39 45 C 39 45.550781 39.449219 46 40 46 L 47 46 C 48.644531 46 50 44.644531 50 43 L 50 10 C 50 8.355469 48.644531 7 47 7 Z M 3 9 L 47 9 C 47.554688 9 48 9.445313 48 10 L 48 43 C 48 43.554688 47.554688 44 47 44 L 41 44 L 41 43.8125 C 41.558594 43.1875 42 42.417969 42 41.5 C 42 39.578125 40.421875 38 38.5 38 C 36.578125 38 35 39.578125 35 41.5 C 35 42.417969 35.441406 43.1875 36 43.8125 L 36 44 L 14 44 L 14 43.8125 C 14.558594 43.1875 15 42.417969 15 41.5 C 15 39.578125 13.421875 38 11.5 38 C 9.578125 38 8 39.578125 8 41.5 C 8 42.417969 8.441406 43.1875 9 43.8125 L 9 44 L 3 44 C 2.445313 44 2 43.554688 2 43 L 2 10 C 2 9.445313 2.445313 9 3 9 Z M 16.46875 13 C 14.027344 13.054688 12.292969 14.128906 11.5625 15.75 C 10.894531 17.230469 11.011719 18.960938 11.4375 20.75 C 11.199219 21.117188 11.054688 21.554688 11.125 22.09375 L 11.09375 22.09375 C 11.097656 22.121094 11.121094 22.128906 11.125 22.15625 C 11.222656 23.035156 11.640625 23.601563 12.15625 23.96875 C 12.265625 24.464844 12.378906 24.96875 12.59375 25.375 C 12.738281 25.644531 12.890625 25.875 13.0625 26.09375 C 13.09375 26.132813 13.15625 26.152344 13.1875 26.1875 L 13.1875 27.5625 C 13.0625 27.777344 12.835938 28.019531 12.28125 28.28125 C 11.671875 28.566406 10.835938 28.828125 9.96875 29.1875 C 9.101563 29.546875 8.167969 30 7.40625 30.75 C 6.644531 31.5 6.089844 32.59375 6 33.9375 L 5.9375 35 L 27.0625 35 L 27 33.9375 C 26.910156 32.59375 26.351563 31.5 25.59375 30.75 C 24.835938 30 23.917969 29.546875 23.0625 29.1875 C 22.207031 28.828125 21.417969 28.5625 20.84375 28.28125 C 20.3125 28.023438 20.089844 27.816406 20 27.625 C 19.957031 27.164063 19.980469 26.722656 20 26.1875 C 20.03125 26.144531 20.09375 26.105469 20.125 26.0625 C 20.289063 25.839844 20.433594 25.582031 20.5625 25.3125 C 20.757813 24.902344 20.871094 24.421875 20.96875 23.9375 C 21.097656 23.839844 21.277344 23.84375 21.375 23.71875 C 21.679688 23.320313 21.851563 22.835938 21.96875 22.1875 L 22 22.15625 C 22.089844 21.609375 21.917969 21.160156 21.6875 20.78125 C 21.941406 19.925781 22.203125 18.777344 22.09375 17.5 C 22.027344 16.730469 21.824219 15.90625 21.3125 15.21875 C 20.835938 14.578125 20.054688 14.136719 19.125 13.96875 C 18.855469 13.722656 18.640625 13.40625 18.3125 13.28125 C 17.757813 13.074219 17.140625 13 16.5 13 Z M 16.5 15 C 16.511719 15 16.519531 15 16.53125 15 C 16.972656 15.003906 17.355469 15.066406 17.59375 15.15625 C 17.839844 15.25 17.90625 15.34375 17.90625 15.34375 L 18.15625 15.8125 L 18.6875 15.90625 C 19.261719 15.976563 19.484375 16.132813 19.6875 16.40625 C 19.890625 16.679688 20.046875 17.125 20.09375 17.65625 C 20.183594 18.714844 19.859375 20.082031 19.65625 20.65625 L 19.375 21.5 L 20 21.84375 C 19.929688 22.1875 19.847656 22.34375 19.8125 22.40625 L 19.1875 22.40625 L 19.09375 23.3125 C 19.058594 23.65625 18.917969 24.113281 18.75 24.46875 C 18.664063 24.648438 18.59375 24.816406 18.53125 24.90625 L 18 25.1875 L 18 25.8125 C 18 26.527344 17.882813 27.097656 18 28.03125 L 18.0625 28.21875 C 18.394531 29.167969 19.171875 29.71875 19.9375 30.09375 C 20.703125 30.46875 21.554688 30.746094 22.3125 31.0625 C 23.070313 31.378906 23.726563 31.730469 24.1875 32.1875 C 24.386719 32.382813 24.398438 32.753906 24.53125 33 L 8.46875 33 C 8.601563 32.753906 8.613281 32.382813 8.8125 32.1875 C 9.273438 31.730469 9.949219 31.378906 10.71875 31.0625 C 11.488281 30.746094 12.335938 30.464844 13.125 30.09375 C 13.914063 29.722656 14.722656 29.234375 15.125 28.3125 L 15.1875 28.09375 L 15.1875 25.1875 L 14.75 24.96875 C 14.753906 24.972656 14.726563 24.941406 14.71875 24.9375 L 14.65625 24.90625 C 14.648438 24.898438 14.664063 24.882813 14.65625 24.875 C 14.582031 24.78125 14.46875 24.617188 14.375 24.4375 C 14.1875 24.078125 14.03125 23.621094 14 23.3125 L 13.90625 22.40625 L 13.21875 22.40625 C 13.199219 22.367188 13.128906 22.273438 13.09375 21.90625 L 13.09375 21.84375 L 13.6875 21.53125 L 13.46875 20.75 C 13 19.019531 12.957031 17.488281 13.375 16.5625 C 13.789063 15.640625 14.570313 15.050781 16.5 15 Z M 37.6875 17 C 33.085938 17 30 20.585938 30 24.6875 C 30 28.585938 33 31 36.5 31 C 37.898438 31 39.011719 30.8125 40.3125 30.3125 L 40.09375 29.1875 C 39.292969 29.585938 38.195313 29.8125 37.09375 29.8125 C 33.992188 29.8125 31.8125 27.898438 31.8125 24.5 C 31.8125 20.601563 34.488281 18.1875 37.6875 18.1875 C 40.886719 18.1875 42.59375 20.210938 42.59375 22.8125 C 42.59375 25.113281 41.492188 26.1875 40.59375 26.1875 C 39.992188 26.1875 39.894531 25.699219 40.09375 24.5 L 40.6875 20.8125 C 40.085938 20.511719 39.085938 20.3125 38.1875 20.3125 C 35.1875 20.3125 33.3125 22.5 33.3125 25 C 33.3125 26.601563 34.292969 27.59375 35.59375 27.59375 C 36.695313 27.59375 37.613281 27.09375 38.3125 26.09375 C 38.414063 27.09375 39.09375 27.59375 40.09375 27.59375 C 42.292969 27.59375 44 25.8125 44 22.8125 C 44 19.414063 41.386719 17 37.6875 17 Z M 37.8125 21.90625 C 38.011719 21.90625 38.207031 22 38.40625 22 L 38.1875 23.90625 C 37.988281 25.105469 37.207031 26 36.40625 26 C 35.804688 26 35.40625 25.613281 35.40625 24.8125 C 35.40625 23.210938 36.414063 21.90625 37.8125 21.90625 Z"/>
        </svg>
    );
};

export const OrderDetailsSVG = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="#000000"
            viewBox="0 0 24 24"
            width="24px"
            height="24px"
        >
            <path d="M 5 3 A 1.0001 1.0001 0 0 0 4 4 L 4 13 A 1.0001 1.0001 0 1 0 6 13 L 6 5 L 19 5 L 19 18 C 19 18.56503 18.56503 19 18 19 C 17.448 19 17 18.551 17 18 L 17 17 C 17 16.448 16.552 16 16 16 L 3 16 C 2.448 16 2 16.448 2 17 L 2 18 C 2 19.657 3.343 21 5 21 L 18 21 C 19.64497 21 21 19.64497 21 18 L 21 4 A 1.0001 1.0001 0 0 0 20 3 L 5 3 z M 8.5 8 C 8.224 8 8 8.224 8 8.5 L 8 9.5 C 8 9.776 8.224 10 8.5 10 L 9.5 10 C 9.776 10 10 9.776 10 9.5 L 10 8.5 C 10 8.224 9.776 8 9.5 8 L 8.5 8 z M 13 8 C 12.448 8 12 8.448 12 9 C 12 9.552 12.448 10 13 10 L 16 10 C 16.552 10 17 9.552 17 9 C 17 8.448 16.552 8 16 8 L 13 8 z M 8.5 12 C 8.224 12 8 12.224 8 12.5 L 8 13.5 C 8 13.776 8.224 14 8.5 14 L 9.5 14 C 9.776 14 10 13.776 10 13.5 L 10 12.5 C 10 12.224 9.776 12 9.5 12 L 8.5 12 z M 13 12 C 12.448 12 12 12.448 12 13 C 12 13.552 12.448 14 13 14 L 16 14 C 16.552 14 17 13.552 17 13 C 17 12.448 16.552 12 16 12 L 13 12 z"/>
        </svg>
    );
};

export const BWFLogoSVG = () => {
    var el = wp.element.createElement;
    var SVG = wp.primitives.SVG;
    var polygon1 = el('polygon', {
        fill: "#1daafc",
        points: "232,3.8 150.4,143.1 117.9,143.1 198.9,3.8 "
    });
    var polygon2 = el('polygon', {
        points: "167.4,3.8 86.8,143.1 5.2,3.8 102.8,3.8 88.2,32.4 86.3,32.4 54.7,32.4 86.3,88.2 134.4,3.8 "
    });
    var svgIcon = el(
        SVG,
        {
            width: 20,
            height: 20,
            viewBox: '0 0 233.1 147.2',
            enableBackground: 'new 0 0 233.1 147.2'
        },
        polygon1,
        polygon2
    );
    return svgIcon;
}
export const SVGIcon = (props) => {
    let {icon, width = '34.537', height = '34.537', size, color = '#007CBA'} = props;
    if (size) {
        width = size;
        height = size;
    }
    switch (icon) {
        case 'customer-details' :
            return (
                <svg className="bwf-block-icon" xmlns="http://www.w3.org/2000/svg" width="57" height="45" viewBox="0 0 57 45">
                    <g id="Customer_Details" dataname="Customer Details" transform="translate(-24 -2)">
                        <g id="Group_1808" dataname="Group 1808">
                            <g id="Rectangle_523" dataname="Rectangle 523" transform="translate(24 2)" fill="none" stroke="currentColor" strokeWidth="3">
                                <rect width="57" height="45" rx="3" stroke="none"/>
                                <rect x="1.5" y="1.5" width="54" height="42" rx="1.5" fill="none"/>
                            </g>
                            <g id="Group_1790" dataname="Group 1790" transform="translate(-375 -447)">
                                <g id="Group_1787" dataname="Group 1787" transform="translate(1 1)">
                                    <g id="Rectangle_527" dataname="Rectangle 527" transform="translate(406 471)" fill="none" stroke="currentColor" strokeWidth="2">
                                        <rect width="13" height="13" rx="2" stroke="none"/>
                                        <rect x="1" y="1" width="11" height="11" rx="1" fill="none"/>
                                    </g>
                                    <g id="Ellipse_178" dataname="Ellipse 178" transform="translate(407 457)" fill="none" stroke="currentColor" strokeWidth="2">
                                        <circle cx="5.5" cy="5.5" r="5.5" stroke="none"/>
                                        <circle cx="5.5" cy="5.5" r="4.5" fill="none"/>
                                    </g>
                                </g>
                                <g id="Group_1786" dataname="Group 1786" transform="translate(0 2)">
                                    <rect id="Rectangle_501" dataname="Rectangle 501" width="21" height="2.5" rx="1" transform="translate(428 456)" fill="currentColor"/>
                                    <rect id="Rectangle_524" dataname="Rectangle 524" width="21" height="2.5" rx="1" transform="translate(428 464)" fill="currentColor"/>
                                    <rect id="Rectangle_525" dataname="Rectangle 525" width="21" height="2.5" rx="1" transform="translate(428 472)" fill="currentColor"/>
                                    <rect id="Rectangle_526" dataname="Rectangle 526" width="21" height="2.5" rx="1" transform="translate(428 480)" fill="currentColor"/>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
            );
            break;
        case 'order-details' :
            return (
                <svg className="bwf-block-icon" xmlns="http://www.w3.org/2000/svg" width="57" height="45" viewBox="0 0 57 45">
                    <g id="Order_Details" dataname="Order Details" transform="translate(-24 -2)">
                        <g id="Rectangle_523" dataname="Rectangle 523" transform="translate(24 2)" fill="none" stroke="currentColor" strokeWidth="3">
                            <rect width="57" height="45" rx="3" stroke="none"/>
                            <rect x="1.5" y="1.5" width="54" height="42" rx="1.5" fill="none"/>
                        </g>
                        <g id="Group_1810" dataname="Group 1810" transform="translate(0 0.001)">
                            <g id="Group_1809" dataname="Group 1809" transform="translate(0 1.001)">
                                <g id="Rectangle_530" dataname="Rectangle 530" transform="translate(53 22)" fill="none" stroke="currentColor" strokeWidth="1">
                                    <rect width="19" height="2" rx="1" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="18" height="1" rx="0.5" fill="none"/>
                                </g>
                                <g id="Rectangle_534" dataname="Rectangle 534" transform="translate(53 34)" fill="none" stroke="currentColor" strokeWidth="1">
                                    <rect width="19" height="2" rx="1" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="18" height="1" rx="0.5" fill="none"/>
                                </g>
                                <g id="Rectangle_535" dataname="Rectangle 535" transform="translate(53 30)" fill="none" stroke="currentColor" strokeWidth="1">
                                    <rect width="19" height="2" rx="1" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="18" height="1" rx="0.5" fill="none"/>
                                </g>
                                <g id="Rectangle_536" dataname="Rectangle 536" transform="translate(53 26)" fill="none" stroke="currentColor" strokeWidth="1">
                                    <rect width="19" height="2" rx="1" stroke="none"/>
                                    <rect x="0.5" y="0.5" width="18" height="1" rx="0.5" fill="none"/>
                                </g>
                            </g>
                            <g id="Rectangle_528" dataname="Rectangle 528" transform="translate(33 10)" fill="none" stroke="currentColor" strokeWidth="2">
                                <rect width="39" height="8" rx="2" stroke="none"/>
                                <rect x="1" y="1" width="37" height="6" rx="1" fill="none"/>
                            </g>
                            <path id="Path_691" dataname="Path 691" d="M110.974,93.092V82.943L103.487,79.2,96,82.943V93.092l7.487,3.743ZM103.487,86.6l-2.08-1.248,4.991-2.828,2.08,1Zm1.081-4.991-4.741,2.745L98.5,83.525l4.991-2.5Zm-6.9,3.327,4.991,3.078v1.825h1.664V88.017l4.991-3.078v7.154L103.487,95l-5.823-2.912Zm0,0" transform="translate(-63 -58.197)" fill="currentColor"/>
                        </g>
                    </g>
                </svg>
            );
            break;
        default:
            return (<></>);
    }
}