import {__} from '@wordpress/i18n';
import {PanelBody} from '@wordpress/components';

const BWFSidebarPanel = () => {
    const DATA = [
        {label: __('Customer First Name'), code: '[wfty_customer_first_name]'},
        {label: __('Customer Last Name'), code: '[wfty_customer_last_name]'},
        {label: __('Customer Email'), code: '[wfty_customer_email]'},
        {label: __('Customer Phone Number'), code: '[wfty_customer_phone_number]'},
        {label: __('Order Number'), code: '[wfty_order_number]'}
    ];
    return (
        <PanelBody scrollAfterOpen={false} title={__('Personalization Shortcodes')}>
            <div className="components-notice is-info bwf-notice">{__('To personalize Thank You Page with different, use these merge tags-')}</div>
            {
                DATA.map((dt, index) => {
                    return (
                        <div className="bwf-shortcodes-wrap">
                            <label htmlFor={'bwf-code-' + index}>{dt.label}</label>
                            <input type="text" id={'bwf-code-' + index} readOnly value={dt.code} onClick={event => event.target.select()}/>
                        </div>
                    )
                })
            }
        </PanelBody>
    )
}

export default BWFSidebarPanel
