/**
 * WordPress dependencies
 */
import {__} from '@wordpress/i18n';
import {PluginSidebar, PluginSidebarMoreMenuItem} from '@wordpress/edit-post';
import {withSelect, withDispatch} from '@wordpress/data';
import {PanelBody, ButtonGroup, Button} from '@wordpress/components';
import {compose} from '@wordpress/compose';
import {useEffect} from '@wordpress/element';
import {applyFilters} from '@wordpress/hooks';
import BWFSidebarPanel from './panel';
import {FontSettings} from '../components'
import {systemFonts} from 'WFTY/utils';

const reviseData = (oldData, newData) => Object
    .keys(newData)
    .reduce((prev, key) => {
        if (undefined !== oldData && oldData[key] === newData[key]) {
            return prev;
        }

        return {
            ...prev,
            [key]: newData[key],
        };
    }, {});

function BWFConfig({meta, oldMeta, onUpdateFont}) {

    const onUpdatePreview = font => {
        if (jQuery('#bwfblock-default-font').length > 0) {
            jQuery('#bwfblock-default-font').remove();
        }
        if (font) {
            jQuery("body").append(`<style id="bwfblock-default-font">#editor .editor-styles-wrapper { font-family:${font}; }</style>`);
        }

    }
    useEffect(() => {
        if ('undefined' !== typeof WebFont) {
            if (meta && meta.bwfblock_default_font) {
                if (!systemFonts.includes(meta.bwfblock_default_font)) {
                    WebFont.load({
                        google: {
                            families: [meta.bwfblock_default_font],
                        },
                    });
                }
            }
        }
    }, [])

    return (
        <>
            <PluginSidebarMoreMenuItem target="sidebar-name">
                {__('Woofunnels')}
            </PluginSidebarMoreMenuItem>
            <PluginSidebar name="Woofunnels" title={__('Woofunnels Blocks')} className="bwf-block-sidebar">
                <PanelBody scrollAfterOpen={false} title={__('Default Font Family')}>
                    <FontSettings
                        font={meta && meta.bwfblock_default_font ? {family: meta.bwfblock_default_font} : {}}
                        onChange={(value) => {
                            const {family = ''} = value;
                            onUpdateFont(family, meta, oldMeta);
                            onUpdatePreview(family);
                        }}
                        disable={['font-size', 'font-weight']}
                    />
                </PanelBody>
                <BWFSidebarPanel/>
            </PluginSidebar>
        </>
    )
}

export default compose([
    withSelect((select) => {
        const postMeta = select('core/editor').getEditedPostAttribute('meta');
        const oldPostMeta = select('core/editor').getCurrentPostAttribute('meta');
        return {
            meta: {...oldPostMeta, ...postMeta},
            oldMeta: oldPostMeta,
        };
    }),
    withDispatch((dispatch) => ({
        onUpdateFont(value, newMeta, oldMeta) {
            const meta = {
                ...reviseData(oldMeta, newMeta),
                bwfblock_default_font: value,
            };
            dispatch('core/editor').editPost({meta});
        },
    })),
])(BWFConfig);


