/**
 * WordPress Global Objects
 */
import {useEffect} from '@wordpress/element';
import BWFBlocksInspectorControl from './blocks-inspector';

const BWFBlocksInspectorControlInner = (props) => {
    const {setAttributes, BWFGeneral, BWFStyle} = props;

    return (
        <BWFBlocksInspectorControl {...props}>
            {(tab, data) => {
                if ('general' === tab) {
                    return <BWFGeneral {...props} />;
                }
                // eslint-disable-next-line react-hooks/rules-of-hooks
                //  useEffect(
                //      () => setAttributes({ screen: data.device }),
                //      [data.device]
                //  );
                return <BWFStyle {...props} screen={data.device}/>;
            }}
        </BWFBlocksInspectorControl>
    );
};

export default BWFBlocksInspectorControlInner;
 