/**
 * External dependencies
 */
 import { merge, omit } from 'lodash';

 /**
  * WordPress dependencies
  */
 import registerBlock from 'WFTY/utils/register-block';
 import { __ } from '@wordpress/i18n';
 import 'regenerator-runtime/runtime.js';
 
 /**
  * Internal dependencies
  */
 import './attributes';
 import './editor.scss';
 import './plugins';
 
 // Add WooFunnel Block Category Icon
 ( function () {
	 const el = wp.element.createElement;
	 const SVG = wp.primitives.SVG;
	 const polygon1 = el( 'polygon', {
		 fill: '#1daafc',
		 points: '232,3.8 150.4,143.1 117.9,143.1 198.9,3.8 ',
	 } );
	 const polygon2 = el( 'polygon', {
		 points:
			 '167.4,3.8 86.8,143.1 5.2,3.8 102.8,3.8 88.2,32.4 86.3,32.4 54.7,32.4 86.3,88.2 134.4,3.8 ',
	 } );
	 const svgIcon = el(
		 SVG,
		 {
			 width: 20,
			 height: 20,
			 viewBox: '0 0 233.1 147.2',
			 enableBackground: 'new 0 0 233.1 147.2',
		 },
		 polygon1,
		 polygon2
	 );
	 wp.blocks.updateCategory( 'woofunnels', { icon: svgIcon } );
 } )();
 
 // Import all index.js and register all the blocks found (if name & settings are exported by the script)
 const importAllAndRegister = ( r ) => {
	 r.keys().forEach( ( key ) => {
		 const { metadata, settings } = r( key );
		 const { slug, ...blockData } = metadata;
 
		 const blockSettings = merge( blockData, settings );
		 try {
			 return (
				 slug && blockSettings && registerBlock( slug, blockSettings )
			 );
		 } catch ( error ) {
			 console.error( `Could not register ${ slug } block` ) // eslint-disable-line
		 }
	 } );
 };
 
 importAllAndRegister( require.context( './blocks', true, /index\.js$/ ) );
 
 function handleChange(
	 { hScriptSelectors, bScriptSelectors, hLinkSelector },
	 callback
 ) {
	 setTimeout( () => {
		 const editorFrame = document.querySelector(
			 'iframe[name="editor-canvas"]'
		 );
		 if ( editorFrame ) {
			 const head = editorFrame.contentWindow.document.querySelector(
				 'head'
			 );
			 const body = editorFrame.contentWindow.document.querySelector(
				 'body'
			 );
 
			 //adding class to disable shimmer effect
			 body.classList.add( 'wfacp_editor_active' );
 
			 //Adds font-family in head
			 if ( hLinkSelector ) {
				 const links = document.querySelectorAll( hLinkSelector );
				 links.forEach( ( link ) => {
					 const lk = document.createElement( 'link' );
					 lk.rel = link.rel;
					 lk.href = link.href;
					 lk.id = link.id;
					 head.appendChild( lk );
				 } );
			 }
 
			 //Adds scrips in head
			 if ( hScriptSelectors ) {
				 const hscripts = document.querySelectorAll( hScriptSelectors );
				 hscripts.forEach( ( script ) => {
					 const sc = document.createElement( 'script' );
					 sc.id = script.id;
					 sc.src = script.src;
					 head.appendChild( sc );
				 } );
			 }
 
			 //Adds scrips in body
			 if ( bScriptSelectors ) {
				 const bscripts = document.querySelectorAll( bScriptSelectors );
				 bscripts.forEach( ( script ) => {
					 const sc = document.createElement( 'script' );
					 sc.id = script.id;
					 if ( script.id.includes( '-js-extra' ) ) {
						 sc.innerText = script.innerText;
						 sc.type = 'text/javascript';
					 } else {
						 sc.src = script.src;
					 }
					 body.appendChild( sc );
				 } );
			 }
			 if ( callback ) {
				 setTimeout( () => {
					 callback( editorFrame.contentWindow.document );
				 }, 500 );
			 }
		 }
	 }, 500 );
 }
 
 //adds script/style in iframe editor for mobile and desktop
 let isAdded = false;
 const observer = new MutationObserver( function ( mutations ) {
	 if (
		 ! isAdded &&
		 document.querySelector( 'iframe[name="editor-canvas"]' )
	 ) {
		 //console.log("It's in the DOM!");
		 const hScriptSelectors = '';
		 const bScriptSelectors = '';
		 const cb = ( iframeDoc ) => {
			 const event = iframeDoc.createEvent( 'Event' );
			 event.initEvent( 'wfacp_setup', false, true );
			 iframeDoc.body.dispatchEvent( event );
		 };
		 const hLinkSelector = 'link#wffn_frontend_tp_css-css';
		 handleChange(
			 { hScriptSelectors, bScriptSelectors, hLinkSelector },
			 cb
		 );
		 isAdded = true;
	 } else if (
		 isAdded &&
		 ! document.querySelector( 'iframe[name="editor-canvas"]' )
	 ) {
		 isAdded = false;
	 }
 } );
 
 observer.observe( document, { childList: true, subtree: true } );
 addEventListener( 'unload', () => {
	 observer.disconnect();
 } );