/**
 * Step Component
 *
 */

/**
 * Internal block libraries
 */
import {__} from '@wordpress/i18n';

const {Button, Dashicon} = wp.components;

/**
 * Build the Step controls
 * @returns {object} Step settings.
 */
export default function StepControls({
                                         label,
                                         value,
                                         onChange,
                                         min,
                                         max,
                                         step = 1,
                                     }) {
    const onMinus = () => {
        if (value > min) {
            onChange(value - step);
        }
    };
    const onPlus = () => {
        if (value < max) {
            onChange(value + step);
        }
    };
    return (
        onChange ? (
            <div className="components-base-control">
                <p className="components-base-control__label">{label}</p>
                <div className="components-base-control__field bwf-flex-center bwf-step-control">
                    <Button
                        className="bwf-step-btn"
                        isDefault
                        onClick={onMinus}
                    >
                        <Dashicon icon="arrow-left"/>
                    </Button>
                    <input
                        className="components-step-control__number"
                        type="number"
                        onChange={(event) =>
                            onChange(Number(event.target.value))
                        }
                        aria-label={label}
                        value={value}
                        min={min}
                        max={max}
                        step={step}
                    />
                    <Button className="bwf-step-btn" isDefault onClick={onPlus}>
                        <Dashicon icon="arrow-right"/>
                    </Button>
                </div>
            </div>
        ) : ''
    );
}
