/**
 * WordPress dependencies
 */
import {__} from '@wordpress/i18n';

/**
 * External dependencies
 */
import {AdvancedToolbarControl} from 'WFTY/components';
import {omit} from 'lodash';
import classnames from 'classnames';

const ALIGN_OPTIONS = [
    {
        value: 'left',
        title: __('Align Left', 'funnel-builder'),
        icon: 'editor-alignleft',
    },
    {
        value: 'center',
        title: __('Align Center', 'funnel-builder'),
        icon: 'editor-aligncenter',
    },
    {
        value: 'right',
        title: __('Align Right', 'funnel-builder'),
        icon: 'editor-alignright',
    },
    {
        value: 'justify',
        title: __('Justified', 'funnel-builder'),
        icon: 'editor-justify',
    },
];

const AlignButtonsControl = (props) => {
    const {justified, className} = props;

    return (
        <AdvancedToolbarControl
            {...omit(props, ['justified'])}
            className={classnames([className, 'bwf-align-buttons-control'])}
            controls={ALIGN_OPTIONS.filter((option) => {
                return !justified ? option.value !== 'justify' : true;
            })}
        />
    );
};

AlignButtonsControl.defaultProps = {
    className: '',
    label: __('Align', 'funnel-builder'),
    value: ALIGN_OPTIONS[0].value,
    justified: false,
};

export default AlignButtonsControl;
