/**
 * External dependencies
 */
import {cloneDeep, defaultsDeep, omit} from 'lodash';
/**
 * WordPress dependencies
 */
import {PanelBody} from '@wordpress/components';
import {__} from '@wordpress/i18n';
/**
 * Internal dependencies
 */
import {DimensionsControl} from 'WFTY/components';


const BWFBlockSpacing = (props) => {
    const {attributes: {margin, padding}, children} = props;
    const propsToPass = {...omit(props, ['label', 'initialOpen'])}


    return (
        <PanelBody scrollAfterOpen={false} title={props.label} initialOpen={props.initialOpen}>
            <DimensionsControl
                {...propsToPass}
                label={__('Margin', 'funnel-builder')}
                type={'margin'}
                attrKey={'margin'}
                defaultSync={false}
                attrVal={margin}
            />
            <br/>
            <br/>
            <DimensionsControl
                {...propsToPass}
                label={__('Padding', 'funnel-builder')}
                attrKey={'padding'}
                defaultSync={false}
                attrVal={padding}
            />
            {children}
        </PanelBody>
    )
}
BWFBlockSpacing.defaultProps = {
    label: __('Spacing', 'funnel-builder'),
    initialOpen: true
}
export default BWFBlockSpacing;
 