/**
 * WordPress dependencies
 */
import {
    PanelBody,
    SelectControl,
    ColorIndicator,
    CardDivider,
} from '@wordpress/components';
import {__} from '@wordpress/i18n';
import {useState} from '@wordpress/element';

/**
 * Internal dependencies
 */
import {BWFColorPalette, BwfBackground, BorderComponenet} from 'WFTY/components';
import {defaultColors, getCurrentScreen, hoverTab} from 'WFTY/utils';
import TypographySettings, {BoxShadowComponent} from 'WFTY/components/typography';
import {BWFBlockSpacing} from 'WFTY/common'


const BWFStyleTab = (props) => {
    const {
        attributes: {
            headingFont,
            headingTextStyle,
            headingLetterSpacing,
            headingLineHeight,
            headingColor,
            productFont,
            productTextStyle,
            productLetterSpacing,
            productLineHeight,
            productColor,
            subTotalFont,
            subTotalTextStyle,
            subTotalLetterSpacing,
            subTotalLineHeight,
            subTotalColor,
            totalFont,
            totalTextStyle,
            totalLetterSpacing,
            totalLineHeight,
            totalColor,
            variationFont,
            variationTextStyle,
            variationLetterSpacing,
            variationLineHeight,
            variationColor,
            dividerColor,
            subscriptionFont,
            subscriptionTextStyle,
            subscriptionLetterSpacing,
            subscriptionLineHeight,
            subscriptionColor,
            subscriptionBtnColor,
            subscriptionBtnColorHover,
            subscriptionBtnBackground,
            subscriptionBtnBackgroundHover,
            downloadFont,
            downloadTextStyle,
            downloadLetterSpacing,
            downloadLineHeight,
            downloadColor,
            downloadBtnColor,
            downloadBtnColorHover,
            downloadBtnBackground,
            downloadBtnBackgroundHover,
            background,
            boxShadow,
            border
        },
        setAttributes,
    } = props;

    const [screenType, setScreen] = useState('normal');
    const screen = getCurrentScreen();

    return (
        <>
            <PanelBody scrollAfterOpen={false}
                       title={__('Heading', 'funnel-builder')}
                       initialOpen={false}
            >
                <BWFColorPalette
                    label={__('Color')}
                    value={headingColor && headingColor[screen]}
                    onChange={(newColor) => setAttributes({headingColor: {...headingColor, [screen]: newColor}})}
                    disableCustomColors={false}
                    colors={defaultColors}
                    clearable={true}
                />
                <CardDivider/>
                <TypographySettings
                    font={headingFont && headingFont[screen] ? headingFont[screen] : {}}
                    text={headingTextStyle && headingTextStyle[screen] ? headingTextStyle[screen] : {}}
                    lineHeight={headingLineHeight && headingLineHeight[screen] ? headingLineHeight[screen] : {}}
                    letterSpacing={headingLetterSpacing && headingLetterSpacing[screen] ? headingLetterSpacing[screen] : {}}
                    onChangeFont={(value) => setAttributes({headingFont: {...headingFont, [screen]: value}})}
                    onChangeText={(value) => setAttributes({headingTextStyle: {...headingTextStyle, [screen]: value}})}
                    onChangeLineHeight={(value) => setAttributes({headingLineHeight: {...headingLineHeight, [screen]: value}})}
                    onChangeLetterSpacing={(value) => setAttributes({headingLetterSpacing: {...headingLetterSpacing, [screen]: value}})}
                />


            </PanelBody>

            <PanelBody scrollAfterOpen={false}
                       title={__('Details', 'funnel-builder')}
                       initialOpen={false}
            >
                <PanelBody scrollAfterOpen={false}
                           title={__('Product', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={productColor && productColor[screen]}
                        onChange={(newColor) => setAttributes({productColor: {...productColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={productFont && productFont[screen] ? productFont[screen] : {}}
                        text={productTextStyle && productTextStyle[screen] ? productTextStyle[screen] : {}}
                        lineHeight={productLineHeight && productLineHeight[screen] ? productLineHeight[screen] : {}}
                        letterSpacing={productLetterSpacing && productLetterSpacing[screen] ? productLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({productFont: {...productFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({productTextStyle: {...productTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({productLineHeight: {...productLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({productLetterSpacing: {...productLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                </PanelBody>
                <PanelBody scrollAfterOpen={false}
                           title={__('Subtotal', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={subTotalColor && subTotalColor[screen]}
                        onChange={(newColor) => setAttributes({subTotalColor: {...subTotalColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={subTotalFont && subTotalFont[screen] ? subTotalFont[screen] : {}}
                        text={subTotalTextStyle && subTotalTextStyle[screen] ? subTotalTextStyle[screen] : {}}
                        lineHeight={subTotalLineHeight && subTotalLineHeight[screen] ? subTotalLineHeight[screen] : {}}
                        letterSpacing={subTotalLetterSpacing && subTotalLetterSpacing[screen] ? subTotalLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({subTotalFont: {...subTotalFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({subTotalTextStyle: {...subTotalTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({subTotalLineHeight: {...subTotalLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({subTotalLetterSpacing: {...subTotalLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                </PanelBody>
                <PanelBody scrollAfterOpen={false}
                           title={__('Total', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={totalColor && totalColor[screen]}
                        onChange={(newColor) => setAttributes({totalColor: {...totalColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={totalFont && totalFont[screen] ? totalFont[screen] : {}}
                        text={totalTextStyle && totalTextStyle[screen] ? totalTextStyle[screen] : {}}
                        lineHeight={totalLineHeight && totalLineHeight[screen] ? totalLineHeight[screen] : {}}
                        letterSpacing={totalLetterSpacing && totalLetterSpacing[screen] ? totalLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({totalFont: {...totalFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({totalTextStyle: {...totalTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({totalLineHeight: {...totalLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({totalLetterSpacing: {...totalLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                </PanelBody>
                <PanelBody scrollAfterOpen={false}
                           title={__('Variation', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color: ')}
                        value={variationColor && variationColor[screen]}
                        onChange={(newColor) => setAttributes({variationColor: {...variationColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={variationFont && variationFont[screen] ? variationFont[screen] : {}}
                        text={variationTextStyle && variationTextStyle[screen] ? variationTextStyle[screen] : {}}
                        lineHeight={variationLineHeight && variationLineHeight[screen] ? variationLineHeight[screen] : {}}
                        letterSpacing={variationLetterSpacing && variationLetterSpacing[screen] ? variationLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({variationFont: {...variationFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({variationTextStyle: {...variationTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({variationLineHeight: {...variationLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({variationLetterSpacing: {...variationLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                </PanelBody>
                <PanelBody scrollAfterOpen={false}
                           title={__('Divider', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={dividerColor && dividerColor[screen]}
                        onChange={(newColor) => setAttributes({dividerColor: {...dividerColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                </PanelBody>

            </PanelBody>

            {
                /**
                 * Subscription Style Settings
                 */
                <PanelBody scrollAfterOpen={false}
                           title={__('Subscription', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={subscriptionColor && subscriptionColor[screen]}
                        onChange={(newColor) => setAttributes({subscriptionColor: {...subscriptionColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={subscriptionFont && subscriptionFont[screen] ? subscriptionFont[screen] : {}}
                        text={subscriptionTextStyle && subscriptionTextStyle[screen] ? subscriptionTextStyle[screen] : {}}
                        lineHeight={subscriptionLineHeight && subscriptionLineHeight[screen] ? subscriptionLineHeight[screen] : {}}
                        letterSpacing={subscriptionLetterSpacing && subscriptionLetterSpacing[screen] ? subscriptionLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({subscriptionFont: {...subscriptionFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({subscriptionTextStyle: {...subscriptionTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({subscriptionLineHeight: {...subscriptionLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({subscriptionLetterSpacing: {...subscriptionLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                    <PanelBody scrollAfterOpen={false}
                               title={__('Button', 'funnel-builder')}
                               initialOpen={false}
                    >
                        {hoverTab(screenType, setScreen)}
                        <br/>
                        <BWFColorPalette
                            key={'subscription-color--' + screenType}
                            label={'Label ' + ('hover' === screenType ? ' Hover' : '')}
                            value={
                                'normal' === screenType ? subscriptionBtnColor && subscriptionBtnColor[screen] : subscriptionBtnColorHover && subscriptionBtnColorHover[screen]
                            }
                            onChange={(newColor) => {
                                if ('normal' === screenType) {
                                    setAttributes({subscriptionBtnColor: {...subscriptionBtnColor, [screen]: newColor}})
                                } else {
                                    setAttributes({subscriptionBtnColorHover: {...subscriptionBtnColorHover, [screen]: newColor}})
                                }
                            }}
                            disableCustomColors={false}
                            colors={defaultColors}
                            colors={defaultColors}
                            clearable={true}
                        />
                        <BwfBackground
                            labelPrefix={''}
                            labelSuffix={'hover' === screenType ? ' Hover' : ''}
                            key={'subscription-background--' + screenType}
                            background={
                                'normal' === screenType ? subscriptionBtnBackground && subscriptionBtnBackground[screen] : subscriptionBtnBackgroundHover && subscriptionBtnBackgroundHover[screen]
                            }
                            disable={['image']}
                            onChange={(value) => {
                                if ('normal' === screenType) {
                                    setAttributes({subscriptionBtnBackground: {...subscriptionBtnBackground, [screen]: value}})
                                } else {
                                    setAttributes({subscriptionBtnBackgroundHover: {...subscriptionBtnBackgroundHover, [screen]: value}})
                                }
                            }}
                        />
                    </PanelBody>
                </PanelBody>
            }

            {
                /**
                 * download Style Settings
                 */
                <PanelBody scrollAfterOpen={false}
                           title={__('Download', 'funnel-builder')}
                           initialOpen={false}
                >
                    <BWFColorPalette
                        label={__('Color')}
                        value={downloadColor && downloadColor[screen]}
                        onChange={(newColor) => setAttributes({downloadColor: {...downloadColor, [screen]: newColor}})}
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <CardDivider/>
                    <TypographySettings
                        font={downloadFont && downloadFont[screen] ? downloadFont[screen] : {}}
                        text={downloadTextStyle && downloadTextStyle[screen] ? downloadTextStyle[screen] : {}}
                        lineHeight={downloadLineHeight && downloadLineHeight[screen] ? downloadLineHeight[screen] : {}}
                        letterSpacing={downloadLetterSpacing && downloadLetterSpacing[screen] ? downloadLetterSpacing[screen] : {}}
                        onChangeFont={(value) => setAttributes({downloadFont: {...downloadFont, [screen]: value}})}
                        onChangeText={(value) => setAttributes({downloadTextStyle: {...downloadTextStyle, [screen]: value}})}
                        onChangeLineHeight={(value) => setAttributes({downloadLineHeight: {...downloadLineHeight, [screen]: value}})}
                        onChangeLetterSpacing={(value) => setAttributes({downloadLetterSpacing: {...downloadLetterSpacing, [screen]: value}})}
                        disable={['text-align']}
                    />
                    <PanelBody scrollAfterOpen={false}
                               title={__('Button', 'funnel-builder')}
                               initialOpen={false}
                    >
                        {hoverTab(screenType, setScreen)}
                        <br/>
                        <BWFColorPalette
                            key={'download-color--' + screenType}
                            label={'Label ' + ('hover' === screenType ? ' Hover' : '')}
                            value={
                                'normal' === screenType ? downloadBtnColor && downloadBtnColor[screen] : downloadBtnColorHover && downloadBtnColorHover[screen]
                            }
                            onChange={(newColor) => {
                                if ('normal' === screenType) {
                                    setAttributes({downloadBtnColor: {...downloadBtnColor, [screen]: newColor}})
                                } else {
                                    setAttributes({downloadBtnColorHover: {...downloadBtnColorHover, [screen]: newColor}})
                                }
                            }}
                            disableCustomColors={false}
                            colors={defaultColors}
                            clearable={true}
                        />
                        <BwfBackground
                            labelPrefix={''}
                            labelSuffix={'hover' === screenType ? ' Hover' : ''}
                            key={'download-background--' + screenType}
                            background={
                                'normal' === screenType ? downloadBtnBackground && downloadBtnBackground[screen] : downloadBtnBackgroundHover && downloadBtnBackgroundHover[screen]
                            }
                            disable={['image']}
                            onChange={(value) => {
                                if ('normal' === screenType) {
                                    setAttributes({downloadBtnBackground: {...downloadBtnBackground, [screen]: value}})
                                } else {
                                    setAttributes({downloadBtnBackgroundHover: {...downloadBtnBackgroundHover, [screen]: value}})
                                }
                            }}
                        />
                    </PanelBody>
                </PanelBody>
            }

            {
                /**
                 * Block Spacing
                 * property include Margin/Padding
                 */
                <BWFBlockSpacing {...props} initialOpen={false}/>

            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Background', 'funnel-builder')} initialOpen={false}>
                    <BwfBackground
                        background={background && background[screen]}
                        onChange={newBackground => setAttributes({background: {...background, ...{[screen]: newBackground}}})}
                    />
                </PanelBody>
            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Border', 'funnel-builder')} initialOpen={false}>
                    <BorderComponenet
                        border={border}
                        onChange={newVal => setAttributes({border: newVal})}
                    />
                </PanelBody>
            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Box Shadow', 'funnel-builder')} initialOpen={false}>
                    <BoxShadowComponent
                        boxShadow={boxShadow && boxShadow[screen]}
                        onChange={newBoxShadow => setAttributes({boxShadow: {...boxShadow, ...{[screen]: newBoxShadow}}})}
                    />
                </PanelBody>
            }
        </>
    );
};
export default BWFStyleTab;
