/**
 * External dependencies
 */
import {times} from 'lodash';

/**
 * WordPress dependencies
 */
import {PanelBody, TextControl, Notice, CardDivider, ToggleControl} from '@wordpress/components';
import {__} from '@wordpress/i18n';

/**
 * Internal dependencies
 */

const BWFGeneralTab = (props) => {
    const {
        attributes: {
            anchor,
            orderHeading,
            uniqueID,
            subscriptionHeading,
            downloadHeading,
            downloadBtnText,
            downloadFileCount,
            downloadFileExpiry,
            orderProductImage,
            downloadPreview,
            subscriptionPreview
        },
        setAttributes,
    } = props;

    return (
        <>
            <PanelBody scrollAfterOpen={false} title={__('Order Details')} initialOpen={true}>
                <TextControl
                    label={__('Heading', 'funnel-builder')}
                    value={orderHeading}
                    onChange={orderHeading => setAttributes({orderHeading})}
                />
                <CardDivider/>

                <ToggleControl
                    label={__('Show Image')}
                    checked={orderProductImage}
                    onChange={orderProductImage => setAttributes({orderProductImage})}
                />
            </PanelBody>
            <PanelBody scrollAfterOpen={false} title={__('Subscription')} initialOpen={false}>
                <div className="components-notice is-error bwf-notice">{__('This section will only show up in case of order will have subscription.', 'funnel-builder')}</div>
                <TextControl
                    label={__('Heading', 'funnel-builder')}
                    value={subscriptionHeading}
                    onChange={subscriptionHeading => setAttributes({subscriptionHeading})}
                />
                <ToggleControl
                    label={__('Show Subscription Preview')}
                    checked={subscriptionPreview}
                    onChange={subscriptionPreview => setAttributes({subscriptionPreview})}
                />
            </PanelBody>
            <PanelBody scrollAfterOpen={false} title={__('Download')} initialOpen={false}>
                <div className="components-notice is-error bwf-notice">{__('This section will only show up in case of order will have downloads.', 'funnel-builder')}</div>
                <TextControl
                    label={__('Heading', 'funnel-builder')}
                    value={downloadHeading}
                    onChange={downloadHeading => setAttributes({downloadHeading})}
                />
                {/* <CardDivider /> */}

                <TextControl
                    label={__('Download Button Text', 'funnel-builder')}
                    value={downloadBtnText}
                    onChange={downloadBtnText => setAttributes({downloadBtnText})}
                />
                {/* <CardDivider /> */}


                <ToggleControl
                    label={__('Show Download Preview')}
                    checked={downloadPreview}
                    onChange={downloadPreview => setAttributes({downloadPreview})}
                />

                <ToggleControl
                    label={__('Show File Downloads Column')}
                    checked={downloadFileCount}
                    onChange={downloadFileCount => setAttributes({downloadFileCount})}
                />
                {/* <CardDivider /> */}

                <ToggleControl
                    label={__('Show File Expiry Column')}
                    checked={downloadFileExpiry}
                    onChange={downloadFileExpiry => setAttributes({downloadFileExpiry})}
                />
            </PanelBody>
        </>
    );
};
export default BWFGeneralTab;
