/**
 * Internal deepndencies
 */
import {
    backgroundCss,
    borderSettingsCss,
    getBoxShadowSettingCss,
    spaceSettingsCss,
    computeTypo,
    computeLetterStyle,
} from 'WFTY/components/css';

import {minifyCSS, getCurrentScreen} from 'WFTY/utils';

const editorStylePreview = (props, screen) => {
    const {
        attributes: {
            margin,
            padding,
            headingFont,
            headingTextStyle,
            headingLetterSpacing,
            headingLineHeight,
            headingColor,
            productFont,
            productTextStyle,
            productLetterSpacing,
            productLineHeight,
            productColor,
            subTotalFont,
            subTotalTextStyle,
            subTotalLetterSpacing,
            subTotalLineHeight,
            subTotalColor,
            totalFont,
            totalTextStyle,
            totalLetterSpacing,
            totalLineHeight,
            totalColor,
            variationFont,
            variationTextStyle,
            variationLetterSpacing,
            variationLineHeight,
            variationColor,
            dividerColor,
            subscriptionFont,
            subscriptionTextStyle,
            subscriptionLetterSpacing,
            subscriptionLineHeight,
            subscriptionColor,
            subscriptionBtnColor,
            subscriptionBtnColorHover,
            subscriptionBtnBackground,
            subscriptionBtnBackgroundHover,
            downloadFont,
            downloadTextStyle,
            downloadLetterSpacing,
            downloadLineHeight,
            downloadColor,
            downloadBtnColor,
            downloadBtnColorHover,
            downloadBtnBackground,
            downloadBtnBackgroundHover,
            background,
            boxShadow,
            border,
            uniqueID,
        },
    } = props;
    const uniqueClass = `.wfty-order-details-block.wfty-${uniqueID} .wfty_wrap`;
    return (`
		${uniqueClass} {
			${margin && margin[screen] ? spaceSettingsCss(margin[screen], 'margin') : ''}
			${padding && padding[screen] ? spaceSettingsCss(padding[screen], 'padding') : ''}
			${boxShadow && boxShadow[screen] ? `box-shadow:${getBoxShadowSettingCss(boxShadow[screen])};` : ''}
			${border && border[screen] ? borderSettingsCss(border[screen]) : ''}
			${background && background[screen] ? backgroundCss(background[screen]) : ''}
		}
		${uniqueClass} .wfty_title {
			${headingFont && headingFont[screen] ? computeTypo(headingFont[screen], 'font') : ''}
			${headingTextStyle && headingTextStyle[screen] ? computeTypo(headingTextStyle[screen], 'text') : ''}
			${headingLetterSpacing && headingLetterSpacing[screen] ? computeLetterStyle(headingLetterSpacing[screen]) : ``}
			${headingLineHeight && headingLineHeight[screen] ? computeLetterStyle(headingLineHeight[screen], 'line-height') : ``}
			${headingColor && headingColor[screen] ? `color:${headingColor[screen]};` : ``}
		}
		${uniqueClass} .wfty_order_details .wfty_pro_list_cont .wfty_pro_list .wfty_t, ${uniqueClass} .wfty_order_details .wfty_pro_list_cont .wfty_pro_list .woocommerce-Price-amount.amount, ${uniqueClass} .wfty_order_details .wfty_pro_list_cont .wfty_pro_list .woocommerce-Price-amount.amount span{
			${productFont && productFont[screen] ? computeTypo(productFont[screen], 'font') : ''}
			${productTextStyle && productTextStyle[screen] ? computeTypo(productTextStyle[screen], 'text') : ''}
			${productLetterSpacing && productLetterSpacing[screen] ? computeLetterStyle(productLetterSpacing[screen]) : ``}
			${productLineHeight && productLineHeight[screen] ? computeLetterStyle(productLineHeight[screen], 'line-height') : ``}
			${productColor && productColor[screen] ? `color:${productColor[screen]};` : ``}
		}
		${uniqueClass} .wfty_order_details .wfty_pro_list_cont table tr:not(:last-child) * {
			${subTotalFont && subTotalFont[screen] ? computeTypo(subTotalFont[screen], 'font') : ''}
			${subTotalTextStyle && subTotalTextStyle[screen] ? computeTypo(subTotalTextStyle[screen], 'text') : ''}
			${subTotalLetterSpacing && subTotalLetterSpacing[screen] ? computeLetterStyle(subTotalLetterSpacing[screen]) : ``}
			${subTotalLineHeight && subTotalLineHeight[screen] ? computeLetterStyle(subTotalLineHeight[screen], 'line-height') : ``}
			${subTotalColor && subTotalColor[screen] ? `color:${subTotalColor[screen]};` : ``}
		}
		
		${uniqueClass} .wfty_order_details .wfty_pro_list_cont table tr:last-child * {
			${totalFont && totalFont[screen] ? computeTypo(totalFont[screen], 'font') : ''}
			${totalTextStyle && totalTextStyle[screen] ? computeTypo(totalTextStyle[screen], 'text') : ''}
			${totalLetterSpacing && totalLetterSpacing[screen] ? computeLetterStyle(totalLetterSpacing[screen]) : ``}
			${totalLineHeight && totalLineHeight[screen] ? computeLetterStyle(totalLineHeight[screen], 'line-height') : ``}
			${totalColor && totalColor[screen] ? `color:${totalColor[screen]};` : ``}
		}
		${uniqueClass} .wfty_order_details .wfty_pro_list_cont .wfty_pro_list .wfty_info * {
			${variationFont && variationFont[screen] ? computeTypo(variationFont[screen], 'font') : ''}
			${variationTextStyle && variationTextStyle[screen] ? computeTypo(variationTextStyle[screen], 'text') : ''}
			${variationLetterSpacing && variationLetterSpacing[screen] ? computeLetterStyle(variationLetterSpacing[screen]) : ``}
			${variationLineHeight && variationLineHeight[screen] ? computeLetterStyle(variationLineHeight[screen], 'line-height') : ``}
			${variationColor && variationColor[screen] ? `color:${variationColor[screen]};` : ``}
		}
		${uniqueClass} .wfty_order_details table tfoot tr:last-child th, ${uniqueClass} .wfty_order_details table tfoot tr:last-child td, ${uniqueClass} .wfty_order_details table {
			${dividerColor && dividerColor[screen] ? `border-top-color:${dividerColor[screen]};` : ``}
		}
		
		${uniqueClass} .wfty_subscription table tbody td:not(:last-child), ${uniqueClass} .wfty_subscription table tbody td:not(:last-child) *, ${uniqueClass} .wfty_subscription table tr th *, ${uniqueClass} .wfty_subscription table tr tbody td:not(:last-child), ${uniqueClass} .wfty_subscription table tr tbody td:not(:last-child) * {
			${subscriptionTextStyle && subscriptionTextStyle[screen] ? computeTypo(subscriptionTextStyle[screen], 'text') : ''}
			${subscriptionFont && subscriptionFont[screen] ? computeTypo(subscriptionFont[screen], 'font') : ''}
			${subscriptionLetterSpacing && subscriptionLetterSpacing[screen] ? computeLetterStyle(subscriptionLetterSpacing[screen]) : ``}
			${subscriptionLineHeight && subscriptionLineHeight[screen] ? computeLetterStyle(subscriptionLineHeight[screen], 'line-height') : ``}
			${subscriptionColor && subscriptionColor[screen] ? `color:${subscriptionColor[screen]};` : ``}

		}
		${uniqueClass} .wfty_subscription table tr td.subscription-actions a {
			${subscriptionFont && subscriptionFont[screen] ? computeTypo(subscriptionFont[screen], 'font') : ''}
			${subscriptionBtnColor && subscriptionBtnColor[screen] ? `color:${subscriptionBtnColor[screen]};` : ``}
			${subscriptionBtnBackground && subscriptionBtnBackground[screen] ? backgroundCss(subscriptionBtnBackground[screen]) : ''}
		}
		${uniqueClass} .wfty_subscription table tr td.subscription-actions:hover a {
			${subscriptionBtnColorHover && subscriptionBtnColorHover[screen] ? `color:${subscriptionBtnColorHover[screen]};` : ``}
			${subscriptionBtnBackgroundHover && subscriptionBtnBackgroundHover[screen] ? backgroundCss(subscriptionBtnBackgroundHover[screen]) : ''}
		}

		${uniqueClass} table.wfty_order_downloads tr td:not(:last-child),  ${uniqueClass} table.wfty_order_downloads thead * {
			${downloadFont && downloadFont[screen] ? computeTypo(downloadFont[screen], 'font') : ''}
			${downloadTextStyle && downloadTextStyle[screen] ? computeTypo(downloadTextStyle[screen], 'text') : ''}
			${downloadLetterSpacing && downloadLetterSpacing[screen] ? computeLetterStyle(downloadLetterSpacing[screen]) : ``}
			${downloadLineHeight && downloadLineHeight[screen] ? computeLetterStyle(downloadLineHeight[screen], 'line-height') : ``}
			${downloadColor && downloadColor[screen] ? `color:${downloadColor[screen]};` : ``}
		}
		${uniqueClass} table.wfty_order_downloads tr td.download-file a {
			${downloadFont && downloadFont[screen] ? computeTypo(downloadFont[screen], 'font') : ''}
			${downloadBtnColor && downloadBtnColor[screen] ? `color:${downloadBtnColor[screen]};` : ``}
			${downloadBtnBackground && downloadBtnBackground[screen] ? backgroundCss(downloadBtnBackground[screen]) : ''}
		}
		${uniqueClass} table.wfty_order_downloads tr td.download-file:hover a {
			${downloadBtnColorHover && downloadBtnColorHover[screen] ? `color:${downloadBtnColorHover[screen]};` : ``}
			${downloadBtnBackgroundHover && downloadBtnBackgroundHover[screen] ? backgroundCss(downloadBtnBackgroundHover[screen]) : ''}
		}
	`);
};

const MobileCss = `.wfty_Dview {
        display: none
    }

    .wfty_Mview {
        display: block
    }

    .wfty_wrap .wfty_box.wfty_product.wfty_def_style {
        padding-bottom: 15px
    }

    .wfty_wrap .wfty_2_col_left, .wfty_wrap .wfty_2_col_right {
        width: 100%;
        float: none;
        padding-right: 0 !important;
    }

    .wfty_wrap .wfty_2_col_right {
        margin-left: 0
    }

    .wfty_wrap .wfty_order_details table tfoot tr:last-child td {
        font-size: 20px;
        line-height: 24px
    }

    .wffn_order_details_table .shop_table.shop_table_responsive thead {
        display: none;
    }

    body .wffn_order_details_table .shop_table.shop_table_responsive tr td {
        display: block;
        text-align: right !important;
        padding: 10px 0 !important;
    }

    body .wffn_order_details_table .shop_table.shop_table_responsive tr td:before {
        content: attr(data-title) ": ";
        float: left;
        display:block;
    }

    .wffn_order_details_table .shop_table.shop_table_responsive tr td.download-file::before {
        content: '';
    }

    .wffn_order_details_table .wfty_wrap .wfty_order_downloads tr th, .wffn_order_details_table .wfty_wrap .wfty_order_downloads tr td {
        width: auto !important;
    }

    .wffn_order_details_table .wfty_wrap .touch-scroll-table {
        width: auto;
        padding: 0;
        position: inherit;
        overflow-y: unset;
        margin-left: 0;
        overflow-x: unset;
        box-shadow: none;
    }`;

const BWFBlockStyle = (props) => {
    const screen = getCurrentScreen();
    return (
        <>
            <style>
                {minifyCSS(editorStylePreview(props, 'desktop'))}
            </style>
            {
                ('tablet' === screen || 'mobile' === screen) &&
                <style>
                    {minifyCSS(editorStylePreview(props, 'tablet'))}
                </style>
            }
            {
                'mobile' === screen &&
                <style>
                    {MobileCss}
                    {minifyCSS(editorStylePreview(props, screen))}
                </style>
            }

        </>
    );
};

export default BWFBlockStyle;
