/**
 * WordPress dependencies
 */
import {
    PanelBody,
    SelectControl,
    ColorIndicator,
} from '@wordpress/components';
import {__} from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import ColorPalette from 'WFTY/components/color';
import {defaultColors, getCurrentScreen} from 'WFTY/utils';
import TypographySettings, {
    BoxShadowComponent,
} from 'WFTY/components/typography';
import BorderComponenet from 'WFTY/components/border';
import BwfBackground from 'WFTY/components/background';
import {BWFBlockSpacing} from 'WFTY/common'

const BWFStyleTab = (props) => {
    const {
        attributes: {
            layout,
            headingFont,
            headingText,
            headingLetterSpacing,
            headingLineHeight,
            headingColor,
            subHeadingFont,
            subHeadingText,
            subHeadingLetterSpacing,
            subHeadingLineHeight,
            subHeadingColor,
            contentFont,
            contentText,
            contentLetterSpacing,
            contentLineHeight,
            contentColor,
            background,
            boxShadow,
            border
        },
        setAttributes,
    } = props;

    const screen = getCurrentScreen();
    return (
        <>
            {
                //Block Heading settings
                <PanelBody scrollAfterOpen={false}
                           title={__('Heading', 'funnel-builder')}
                           initialOpen={false}
                >
                    <div className={'bwf-label'}>
                        {__('Color: ')}
                        <ColorIndicator
                            className="bwf-color-indicator"
                            colorValue={headingColor && headingColor[screen]}
                        />
                    </div>
                    <ColorPalette
                        value={headingColor && headingColor[screen]}
                        onChange={(newColor) =>
                            setAttributes({
                                headingColor: {...headingColor, [screen]: newColor},
                            })
                        }
                        disableCustomColors={false}
                        colors={defaultColors}
                        clearable={true}
                    />
                    <hr/>
                    <TypographySettings
                        font={headingFont && headingFont[screen] ? headingFont[screen] : {}}
                        text={headingText && headingText[screen] ? headingText[screen] : {}}
                        lineHeight={
                            headingLineHeight && headingLineHeight[screen]
                                ? headingLineHeight[screen]
                                : {}
                        }
                        letterSpacing={
                            headingLetterSpacing && headingLetterSpacing[screen]
                                ? headingLetterSpacing[screen]
                                : {}
                        }
                        onChangeFont={(value) => {
                            setAttributes({
                                headingFont: {...headingFont, [screen]: value},
                            });
                        }}
                        onChangeText={(value) => {
                            setAttributes({
                                headingText: {...headingText, [screen]: value},
                            });
                        }}
                        onChangeLineHeight={(value) => {
                            setAttributes({
                                headingLineHeight: {...headingLineHeight, [screen]: value},
                            });
                        }}
                        onChangeLetterSpacing={(value) => {
                            setAttributes({
                                headingLetterSpacing: {
                                    ...headingLetterSpacing,
                                    [screen]: value,
                                },
                            });
                        }}
                    />

                </PanelBody>
            }

            {
                //Block Heading settings
                <PanelBody scrollAfterOpen={false}
                           title={__('Details', 'funnel-builder')}
                           initialOpen={false}
                >
                    <PanelBody scrollAfterOpen={false}
                               title={__('Sub Heading', 'funnel-builder')}
                               initialOpen={false}
                    >
                        <div className={'bwf-label'}>
                            {__('color: ')}
                            <ColorIndicator
                                className="bwf-color-indicator"
                                colorValue={subHeadingColor && subHeadingColor[screen]}
                            />
                        </div>
                        <ColorPalette
                            value={subHeadingColor && subHeadingColor[screen]}
                            onChange={(newColor) =>
                                setAttributes({
                                    subHeadingColor: {...subHeadingColor, [screen]: newColor},
                                })
                            }
                            disableCustomColors={false}
                            colors={defaultColors}
                            clearable={true}
                        />
                        <hr/>
                        <TypographySettings
                            font={subHeadingFont && subHeadingFont[screen] ? subHeadingFont[screen] : {}}
                            text={subHeadingText && subHeadingText[screen] ? subHeadingText[screen] : {}}
                            lineHeight={
                                subHeadingLineHeight && subHeadingLineHeight[screen]
                                    ? subHeadingLineHeight[screen]
                                    : {}
                            }
                            letterSpacing={
                                subHeadingLetterSpacing && subHeadingLetterSpacing[screen]
                                    ? subHeadingLetterSpacing[screen]
                                    : {}
                            }
                            onChangeFont={(value) => {
                                setAttributes({
                                    subHeadingFont: {...subHeadingFont, [screen]: value},
                                });
                            }}
                            onChangeText={(value) => {
                                setAttributes({
                                    subHeadingText: {...subHeadingText, [screen]: value},
                                });
                            }}
                            onChangeLineHeight={(value) => {
                                setAttributes({
                                    subHeadingLineHeight: {...subHeadingLineHeight, [screen]: value},
                                });
                            }}
                            onChangeLetterSpacing={(value) => {
                                setAttributes({
                                    subHeadingLetterSpacing: {
                                        ...subHeadingLetterSpacing,
                                        [screen]: value,
                                    },
                                });
                            }}
                        />


                    </PanelBody>

                    <PanelBody scrollAfterOpen={false}
                               title={__('Details', 'funnel-builder')}
                               initialOpen={false}
                    >
                        <div className={'bwf-label'}>
                            {__('Details Color: ')}
                            <ColorIndicator
                                className="bwf-color-indicator"
                                colorValue={contentColor && contentColor[screen]}
                            />
                        </div>
                        <ColorPalette
                            value={contentColor && contentColor[screen]}
                            onChange={(newColor) =>
                                setAttributes({
                                    contentColor: {...contentColor, [screen]: newColor},
                                })
                            }
                            disableCustomColors={false}
                            colors={defaultColors}
                            clearable={true}
                        />
                        <hr/>
                        <TypographySettings
                            font={contentFont && contentFont[screen] ? contentFont[screen] : {}}
                            text={contentText && contentText[screen] ? contentText[screen] : {}}
                            lineHeight={
                                contentLineHeight && contentLineHeight[screen]
                                    ? contentLineHeight[screen]
                                    : {}
                            }
                            letterSpacing={
                                contentLetterSpacing && contentLetterSpacing[screen]
                                    ? contentLetterSpacing[screen]
                                    : {}
                            }
                            onChangeFont={(value) => {
                                setAttributes({
                                    contentFont: {...contentFont, [screen]: value},
                                });
                            }}
                            onChangeText={(value) => {
                                setAttributes({
                                    contentText: {...contentText, [screen]: value},
                                });
                            }}
                            onChangeLineHeight={(value) => {
                                setAttributes({
                                    contentLineHeight: {...contentLineHeight, [screen]: value},
                                });
                            }}
                            onChangeLetterSpacing={(value) => {
                                setAttributes({
                                    contentLetterSpacing: {
                                        ...contentLetterSpacing,
                                        [screen]: value,
                                    },
                                });
                            }}
                        />

                    </PanelBody>
                </PanelBody>
            }

            {
                /**
                 * Block Spacing
                 * property include Margin/Padding
                 */
                <BWFBlockSpacing {...props} initialOpen={false}/>

            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Background', 'funnel-builder')} initialOpen={false}>
                    <BwfBackground
                        background={background && background[screen]}
                        onChange={newBackground => setAttributes({background: {...background, ...{[screen]: newBackground}}})}
                    />
                </PanelBody>
            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Border', 'funnel-builder')} initialOpen={false}>
                    <BorderComponenet
                        border={border}
                        onChange={newVal => setAttributes({border: newVal})}
                    />
                </PanelBody>
            }
            {
                <PanelBody scrollAfterOpen={false} title={__('Box Shadow', 'funnel-builder')} initialOpen={false}>
                    <BoxShadowComponent
                        boxShadow={boxShadow && boxShadow[screen]}
                        onChange={newBoxShadow => setAttributes({boxShadow: {...boxShadow, ...{[screen]: newBoxShadow}}})}
                    />
                </PanelBody>
            }
        </>
    );
};
export default BWFStyleTab;
