/**
 * External dependencies
 */
import {times} from 'lodash';

/**
 * WordPress dependencies
 */
import {SelectControl, TextControl, PanelBody} from '@wordpress/components';
import {__} from '@wordpress/i18n';

/**
 * Internal dependencies
 */

const BWFGeneralTab = (props) => {
    const {
        attributes: {content, layout},
        setAttributes,
    } = props;

    return (
        <>
            <PanelBody scrollAfterOpen={false} title={__('Heading')} initialOpen={true}>
                <TextControl
                    label={__('Heading', 'funnel-builder')}
                    value={content}
                    onChange={content => setAttributes({content})}
                />
            </PanelBody>
            <PanelBody scrollAfterOpen={false} title={__('Layout')} initialOpen={false}>
                <SelectControl
                    label={__('Layout', 'funnel-builder')}
                    options={[
                        {label: 'Two Columns', value: '2c'},
                        {label: 'Full Width', value: '1c'},
                    ]}
                    value={layout && layout[screen] ? layout[screen] : ''}
                    onChange={newLayout => setAttributes({layout: {...layout, ...{[screen]: newLayout}}})}
                />
            </PanelBody>
        </>

    );
};
export default BWFGeneralTab;
