/* eslint-disable jsx-a11y/anchor-is-valid */

/**
 * External dependencies
 */
import classNames from 'classnames';

/**
 * WordPress dependencies
 */
import {useEffect, Fragment} from '@wordpress/element';
import {__} from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import BWFBlockStyle from './css';
import {fontCheck, getCurrentScreen} from 'WFTY/utils';
import BWFGeneral from './inspector-control/general';
import BWFStyle from './inspector-control/style';
import BWFBlocksInspectorControlInner from 'WFTY/inspector/blocks-inspector-inner';

const {cust_details} = window.wfty_blocks;
const uniqueIDArr = [];

const Edit = (props) => {
    const {
        attributes: {
            anchor,
            content,
            uniqueID,
            layout,
            headingFont,
        },
        className,
        clientId,
        setAttributes,
    } = props;

    useEffect(() => {
        let id = clientId.substr(2, 9).replace('-', '');
        if (!uniqueID || uniqueIDArr.includes(uniqueID)) {
            uniqueIDArr.push(id);
            setAttributes({uniqueID: id});
        } else {
            uniqueIDArr.push(uniqueID);
        }
        fontCheck(props.attributes);
    }, []);

    const screen = getCurrentScreen();

    return (
        <Fragment>
            <BWFBlockStyle {...props} />
            <BWFBlocksInspectorControlInner {...props} BWFGeneral={BWFGeneral} BWFStyle={BWFStyle}/>

            <div className={classNames('wfty-cust-details-block', className, `wfty-${uniqueID}`)} id={anchor}>
                <div className={classNames('wfty_wrap')}>
                    <div className="wfty_box wfty_customer_info">
                        <h2 className="wfty-customer-info-heading wfty_title" dangerouslySetInnerHTML={{__html: content}}/>
                        <div className={classNames(
                            'wfty_content wfty_clearfix wfty_text',
                            {'wfty_full_width': layout && layout.desktop && '1c' === layout.desktop},
                            {'wfty_2c_tab_width': 'tablet' === screen && layout && layout.tablet && '2c' === layout.tablet},
                            {'wfty_2c_mob_width': 'mobile' === screen && layout && layout.mobile && '2c' === layout.mobile},
                        )}>
                            <div className="wfty_2_col_left">
                                <div className="wfty_text_bold"><strong>{__('Email', 'funnel-builder')}</strong></div>
                                <div className="wfty_view">{__('john.doe@example.com')}</div>
                            </div>
                            <div className="wfty_2_col_right">
                                <div className="wfty_text_bold"><strong>{__('Phone', 'funnel-builder')}</strong></div>
                                <div className="wfty_view">{__('(999) 999-9999')}</div>
                            </div>
                            <div className="wfty_clear_15"></div>
                            <div className="wfty_2_col_left">
                                <div className="wfty_text">
                                    <div className="wfty_text_bold"><strong>{__('Billing address', 'funnel-builder')}</strong></div>
                                    <div className="wfty_view">{__('John Doe', 'funnel-builder')}<br/>{__('711-2880 Nulla St', 'funnel-builder')}<br/>{__('New York, NY 10001', 'funnel-builder')}</div>
                                </div>
                            </div>
                            {
                                true === cust_details.shipping ?
                                    <div className="wfty_2_col_right">
                                        <div className="wfty_text">
                                            <div className="wfty_text_bold"><strong>{__('Shipping address', 'funnel-builder')}</strong></div>
                                            <div className="wfty_view">{__('John Doe')}<br/>{__('711-2880 Nulla St')}<br/>{__('New York, NY 10001')}</div>
                                        </div>
                                    </div>
                                    : ''
                            }
                            <div className="wfty_clear"></div>
                        </div>
                    </div>
                </div>
            </div>

        </Fragment>
    );
};
export default Edit;