/**
 * Internal deepndencies
 */
import {
    backgroundCss,
    borderSettingsCss,
    getBoxShadowSettingCss,
    spaceSettingsCss,
    computeTypo,
    computeLetterStyle,
} from 'WFTY/components/css';

import {minifyCSS, getCurrentScreen} from 'WFTY/utils';

const editorStylePreview = (props, screen) => {
    const {
        attributes: {
            margin,
            padding,
            layout,
            headingFont,
            headingText,
            headingLetterSpacing,
            headingLineHeight,
            headingColor,
            subHeadingFont,
            subHeadingText,
            subHeadingLetterSpacing,
            subHeadingLineHeight,
            subHeadingColor,
            contentFont,
            contentText,
            contentLetterSpacing,
            contentLineHeight,
            contentColor,
            background,
            boxShadow,
            border,
            uniqueID,
        },
    } = props;
    const uniqueClass = `.wfty-cust-details-block.wfty-${uniqueID} .wfty_wrap`;
    return (`
		${uniqueClass} {
			${margin && margin[screen] ? spaceSettingsCss(margin[screen], 'margin') : ''}
			${padding && padding[screen] ? spaceSettingsCss(padding[screen], 'padding') : ''}
			${boxShadow && boxShadow[screen] ? `box-shadow:${getBoxShadowSettingCss(boxShadow[screen])};` : ''}
			${border && border[screen] ? borderSettingsCss(border[screen]) : ''}
			${background && background[screen] ? backgroundCss(background[screen]) : ''}
		}
		${uniqueClass} .wfty-customer-info-heading {
			${headingFont && headingFont[screen] ? computeTypo(headingFont[screen], 'font') : ''}
			${headingText && headingText[screen] ? computeTypo(headingText[screen], 'text') : ''}
			${headingLetterSpacing && headingLetterSpacing[screen] ? computeLetterStyle(headingLetterSpacing[screen]) : ``}
			${headingLineHeight && headingLineHeight[screen] ? computeLetterStyle(headingLineHeight[screen], 'line-height') : ``}
			${headingColor && headingColor[screen] ? `color:${headingColor[screen]};` : ``}
		}
		${uniqueClass} .wfty_content .wfty_text_bold strong {
			${subHeadingText && subHeadingText[screen] ? computeTypo(subHeadingText[screen], 'text') : ''}
			${subHeadingFont && subHeadingFont[screen] ? computeTypo(subHeadingFont[screen], 'font') : ''}
			${subHeadingLetterSpacing && subHeadingLetterSpacing[screen] ? computeLetterStyle(subHeadingLetterSpacing[screen]) : ``}
			${subHeadingLineHeight && subHeadingLineHeight[screen] ? computeLetterStyle(subHeadingLineHeight[screen], 'line-height') : ``}
			${subHeadingColor && subHeadingColor[screen] ? `color:${subHeadingColor[screen]};` : ``}

		}
		${uniqueClass} .wfty_content .wfty_view {
			${contentFont && contentFont[screen] ? computeTypo(contentFont[screen], 'font') : ''}
			${contentText && contentText[screen] ? computeTypo(contentText[screen], 'text') : ''}
			${contentLetterSpacing && contentLetterSpacing[screen] ? computeLetterStyle(contentLetterSpacing[screen]) : ``}
			${contentLineHeight && contentLineHeight[screen] ? computeLetterStyle(contentLineHeight[screen], 'line-height') : ``}
			${contentColor && contentColor[screen] ? `color:${contentColor[screen]};` : ``}

		}
	`);
};

const BWFBlockStyle = (props) => {
    const screen = getCurrentScreen();
    return (
        <>
            <style>
                {minifyCSS(editorStylePreview(props, 'desktop'))}
            </style>
            {
                ('tablet' === screen || 'mobile' === screen) &&
                <style>
                    {minifyCSS(editorStylePreview(props, 'tablet'))}
                </style>
            }
            {
                'mobile' === screen &&
                <style>
                    {minifyCSS(editorStylePreview(props, screen))}
                </style>
            }

        </>
    );
};

export default BWFBlockStyle;
