<?php

class WFACP_Pre_Built extends WFACP_Template_Common {
	protected $sidebar_layout_order = [];
	protected $mobile_layout_order = [];
	public $customizer_fields = [];
	public $customizer_fields_data = [];
	protected $layout_setting = [];
	protected $internal_css = [];
	public $customizer_css = [];
	protected $customizer_data = [];
	protected $sections = array( 'wfacp_section' );
	protected $section_keys_data = [];
	protected $current_active_sidebar = [];
	protected $excluded_sidebar_sections = [];
	public $excluded_layout_sections_sidebar = [];
	public $customizer_keys = [
		'style'            => 'wfacp_style',
		'header'           => 'wfacp_header',
		'footer'           => 'wfacp_footer',
		'gbadge'           => 'wfacp_gbadge',
		'product_switcher' => 'wfacp_form_product_switcher',

	];
	public $wfacp_html_fields = [
		'wfacp_html_widget_1' => 'Custom HTML Sidebar-1',
		'wfacp_html_widget_2' => 'Custom HTML Sidebar-2',
		'wfacp_html_widget_3' => 'Custom HTML Below Form',
	];

	protected function __construct() {
		parent::__construct();
		$this->url = WFACP_PLUGIN_URL . '/builder/customizer/templates/' . $this->get_template_slug() . '/views/';
		add_action( 'wfacp_header_print_in_head', [ $this, 'add_style_inline' ] );
		add_action( 'wfacp_header_print_in_head', [ $this, 'typography_custom_css' ] );

		add_action( 'wfacp_after_checkout_page_found', [ $this, 'setup_sidebar_data' ], 100 );
		add_filter( 'wfacp_body_class', [ $this, 'add_custom_cls' ] );
		add_filter( 'wfacp_layout_default_setting', [ $this, 'change_default_setting' ], 10, 2 );
		add_filter( 'wfacp_layout_default_setting', [ $this, 'order_btn_sticky' ], 10, 2 );
		add_filter( 'wfacp_style_default_setting', [ $this, 'multi_tab_default_setting' ], 11, 2 );
		add_filter( 'wfacp_customizer_layout', [ $this, 'customizer_layout_order' ], 11, 2 );

		add_action( 'customize_controls_print_footer_scripts', [ $this, 'form_pop_up_content' ] );
		add_filter( 'woocommerce_order_button_text', [ $this, 'change_order_placed_step_label' ] );
		add_action( 'wfacp_internal_css', [ $this, 'get_embed_localize_data' ], 9 );
		add_filter( 'wfacp_cart_show_product_thumbnail', [ $this, 'enable_show_img_order_summary' ], 10, 2 );
		add_action( 'wp_footer', [ $this, 'print_empty_style_tag' ] );
		add_filter( 'wfacp_disabled_pre_built_header_footer', [ $this, 'remove_built_in_title_tag' ] );

	}

	public function enqueue_script() {
		parent::enqueue_script();

		if ( WFACP_Common::is_customizer() ) {
			$template_fields = $this->get_customizer_fields();
			wp_enqueue_script( 'underscore' );
			wp_enqueue_script( 'wp-util' );
			wp_enqueue_script( 'customizer' );
			wp_enqueue_script( 'customize-base' );
			wp_enqueue_script( 'customize-preview' );
			wp_enqueue_script( 'wfacp_customizer_live', plugin_dir_url( WFACP_PLUGIN_FILE ) . 'assets/js/customizer.js', [], WFACP_VERSION_DEV, true );
			wp_localize_script( 'wfacp_customizer_live', 'wfacp_customizer', array(
				'is_loaded' => 'yes',
				'wfacp_id'  => WFACP_Common::get_id(),
				'fields'    => $template_fields,
				'pd'        => [],
			) );
			wp_enqueue_script( 'customize-selective-refresh' );
		}
	}

	protected function get_localize_data() {
		$parent                  = parent::get_localize_data(); // TODO: Change the autogenerated stub
		$parent['is_customizer'] = WFACP_Common::is_customizer();

		return $parent;
	}

	public function customizer_data() {
		return $this->customizer_data;
	}

	public function control_filter( $control ) {
		if ( in_array( $control->section, $this->get_sections() ) ) {
			return true;
		}

		return false;
	}

	public function get_customizer_fields() {
		return $this->customizer_fields;
	}

	public function add_style_inline() {

		$deskotp_css_style = '';
		$tablet_css_style  = '';
		$mobile_css_style  = '';

		$template_type = $this->get_template_type();


		if ( isset( $this->selected_font_family ) && '' != $this->selected_font_family ) {

			$style_url = 'https://fonts.googleapis.com/css?family=' . urlencode( $this->selected_font_family );


			if ( $value = apply_filters( 'wfacp_enable_font_family', true, $template_type ) ) {
				echo "<link href='" . $style_url . "' rel=stylesheet>";
				$fonts_arr = [ 'body', 'p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', '.select2-results__options', '#wfacp_qr_model_wrap *', '.select2-search--dropdown .select2-search__field' ];

				foreach ( $fonts_arr as $font_key => $font_value ) {
					if ( $font_value == '' ) {
						continue;
					}
					$this->customizer_css['desktop'][ $font_value ]['font-family'] = $this->selected_font_family;
				}
			}
		}


		if ( $template_type == 'embed_form' ) {
			return;
		}


		$pixel_used_property = [ 'font-size', 'border-width' ];

		if ( isset( $this->customizer_css['desktop'] ) && is_array( $this->customizer_css['desktop'] ) && count( $this->customizer_css['desktop'] ) > 0 ) {

			foreach ( $this->customizer_css['desktop'] as $key => $value ) {

				foreach ( $value as $css_property => $css_value ) {
					if ( '' == $css_value ) {
						continue;
					}
					$suffix = '';
					if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
						$suffix = 'px';
					}
					if ( 'px' == $css_value ) {
						$css_value = '0px';
						$suffix    = '';
					}
					$selector          = $css_property . ':' . $css_value . $suffix;
					$style_inline      = $key . '{' . $selector . ';}' . "\n";
					$deskotp_css_style .= $style_inline;

				}
			}
		}

		if ( isset( $this->customizer_css['tablet'] ) && is_array( $this->customizer_css['tablet'] ) && count( $this->customizer_css['tablet'] ) > 0 ) {
			$tablet_css_style .= '@media (max-width: 991px) {';
			foreach ( $this->customizer_css['tablet'] as $key => $value ) {
				foreach ( $value as $css_property => $css_value ) {
					if ( '' == $css_value ) {
						continue;
					}
					$suffix = '';
					if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
						$suffix = 'px';
					}
					if ( 'px' == $css_value ) {
						$css_value = '0px';
						$suffix    = '';
					}
					$selector         = $css_property . ':' . $css_value . $suffix;
					$style_inline     = $key . '{' . $selector . ';}';
					$tablet_css_style .= $style_inline;
				}
			}
			$tablet_css_style .= '}';
		}
		if ( isset( $this->customizer_css['mobile'] ) && is_array( $this->customizer_css['mobile'] ) && count( $this->customizer_css['mobile'] ) > 0 ) {
			$mobile_css_style .= '@media (max-width: 767px) {';
			foreach ( $this->customizer_css['mobile'] as $key => $value ) {
				foreach ( $value as $css_property => $css_value ) {
					if ( '' == $css_value ) {
						continue;
					}
					$suffix = '';
					if ( in_array( $css_property, $pixel_used_property ) && false == strpos( $css_value, 'px' ) ) {
						$suffix = 'px';
					}
					if ( 'px' == $css_value ) {
						$css_value = '0px';
						$suffix    = '';
					}
					$selector         = $css_property . ':' . $css_value . $suffix;
					$style_inline     = $key . '{' . $selector . ';}';
					$mobile_css_style .= $style_inline;
				}
			}
			$mobile_css_style .= '}';
		}


		echo '<style>';

		echo $deskotp_css_style;
		echo $tablet_css_style;
		echo $mobile_css_style;
		echo '</style>';
	}

	public function typography_custom_css() {
		$selected_template_slug = $this->get_template_slug();
		$style_custom_css       = WFACP_Common::get_option( 'wfacp_custom_css_section_' . $selected_template_slug . '_code' );
		if ( empty( $style_custom_css ) ) {
			return;
		}
		echo '<style>' . $style_custom_css . '</style>';
	}

	public function mobile_layout_order() {
		return $this->mobile_layout_order;
	}

	public function get_setup_sidebar_data() {
		return $this->sidebar_layout_order;
	}

	public function setup_sidebar_data() {
		$all_section_data = WFACP_Common::get_option( 'wfacp_layout_section_customizer_data' );
		if ( is_array( $all_section_data ) && count( $all_section_data ) > 0 ) {
			$this->sidebar_layout_order = $all_section_data;
		}
		$this->assign_field_data();
	}

	public function assign_field_data() {
		$selected_template_slug = $this->get_template_slug();
		$this->get_wfacp_version();
		$this->sidebar_layout_order = [ 'wfacp_form', 'wfacp_style' ];
		if ( empty( $this->sidebar_layout_order ) ) {
			return false;
		}

		foreach ( $this->sidebar_layout_order as $s_key => $_value ) {
			$section_key = $_value;
			if ( $section_key == 'wfacp_style' ) {


				$layout_key = '';
				if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
					$layout_key = $selected_template_slug . '_';
				}
				$data = [];

				$data['wfacp_style']['body_background_color'] = WFACP_Common::get_option( $section_key . '_colors_' . $layout_key . 'body_background_color' );

				$data['wfacp_style']['sidebar_background_color'] = WFACP_Common::get_option( $section_key . '_colors_' . $layout_key . 'sidebar_background_color' );

				$data['wfacp_style']['content_fs'] = WFACP_Common::get_option( $section_key . '_typography_' . $layout_key . 'content_fs' );
				$data['wfacp_style']['content_ff'] = WFACP_Common::get_option( $section_key . '_typography_' . $layout_key . 'content_ff' );

				if ( isset( $data['wfacp_style']['content_fs']['desktop'] ) && $data['wfacp_style']['content_fs']['desktop'] != '' ) {
					$desktop_fs                                                                                                                    = $data['wfacp_style']['content_fs']['desktop'] + 4;
					$this->customizer_css['desktop']['.wfacp_main_wrapper .wc-amazon-payments-advanced-populated .create-account h3']['font-size'] = $desktop_fs . 'px';
				}

				if ( isset( $data['wfacp_style']['content_fs']['mobile'] ) && $data['wfacp_style']['content_fs']['mobile'] != '' ) {
					$mobile_fs                                                                                                                     = $data['wfacp_style']['content_fs']['mobile'] + 4;
					$this->customizer_css['desktop']['.wfacp_main_wrapper .wc-amazon-payments-advanced-populated .create-account h3']['font-size'] = $mobile_fs . 'px';
				}


				if ( isset( $data['wfacp_style']['content_ff'] ) && $data['wfacp_style']['content_ff'] != '' ) {
					$this->selected_font_family = $data['wfacp_style']['content_ff'];
				}

				$this->prepare_dynamic_style( $data, $section_key );

				if ( isset( $data['wfacp_style']['body_background_color'] ) ) {
					$this->customizer_css['desktop']['body']                  = array(
						'background' => $data['wfacp_style']['body_background_color'],
					);
					$this->customizer_css['desktop']['.wfacp-main-container'] = array(
						'background' => $data['wfacp_style']['body_background_color'],
					);

					if ( $selected_template_slug == 'layout_2' ) {
						$this->customizer_css['desktop']['body .wfacp-panel-wrapper'] ['background'] = $data['wfacp_style']['body_background_color'];

					}
				}

				if ( isset( $data['wfacp_style']['sidebar_background_color'] ) ) {

					$this->customizer_css['desktop']['.wfacp-right-panel']                                                       = array(
						'background' => $data['wfacp_style']['sidebar_background_color'],
					);
					$this->customizer_css['mobile'][ '.wfacp-mobile .' . $selected_template_slug . '_temp.wfacp-panel-wrapper' ] = array(
						'background' => $data['wfacp_style']['sidebar_background_color'],
					);
					$this->customizer_css['mobile'][ '.wfacp-mobile .' . $selected_template_slug . '_temp .wfacp-form' ]         = array(
						'margin-bottom' => '5px',
					);


				}

				$this->wfacp_font_size( $data[ $section_key ], array(
					'section_key' => $section_key,
					'target_to'   => 'body p',
					'source_from' => 'content_fs',
				) );

				$this->wfacp_font_size( $data[ $section_key ], array(
					'section_key' => $section_key,
					'target_to'   => '.wfacp-comm-inner-inf p',
					'source_from' => 'content_fs',
				) );

				/* update layout 4 fonts */
				if ( $selected_template_slug == 'layout_4' ) {
					$this->wfacp_font_size( $data[ $section_key ], array(
						'section_key' => $section_key,
						'target_to'   => '.wfacp-list-panel p',
						'source_from' => 'content_fs',
					) );
					$this->wfacp_font_size( $data[ $section_key ], array(
						'section_key' => $section_key,
						'target_to'   => '.wfacp-testing-text p',
						'source_from' => 'content_fs',
					) );
				}

				$this->customizer_fields_data['wfacp_style'] = $data;

			} elseif ( $section_key == 'wfacp_form' ) {


				$data = array();

				$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );


				$data['colors'] = $this->get_color_setting( $section_key, $selected_template_slug );


				$layout_key = '';
				if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
					$layout_key = $selected_template_slug . '_';
				}


				/* heading section */
				$data['heading_section'] = $this->get_heading_section( $section_key, $selected_template_slug );

				/* Sub heading section */
				$data['sub_heading_section'] = $this->get_sub_heading_section( $section_key, $selected_template_slug );

				/* Field Style */
				$data['form_data']['field_style']               = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_style_fs' );
				$focus_color                                    = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_focus_color' );
				$data['form_data']['text_below_placeorder_btn'] = WFACP_Common::get_option( $section_key . '_section_text_below_placeorder_btn' );


//				$data['form_data']['field_style']['focus_color']=$focus_color;

				/* product switcher */


				$data['form_data']['field_style_position'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_style_position' );

				$data['border']['form_head']['border-style']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_type' );
				$data['border']['form_head']['border-width']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_width' );
				$data['border']['form_head']['border-color']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_border_color' );
				$data['border']['form_head']['padding-left']  = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_padding' );
				$data['border']['form_head']['padding-right'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_padding' );
				$data['border']['form_head']['margin-bottom'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'rbox_margin' );


				$data['border']['form_field_style']['border-style'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_layout' );
				$data['border']['form_field_style']['border-width'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_width' );
				$data['border']['form_field_style']['border-color'] = WFACP_Common::get_option( $section_key . '_section_' . $layout_key . 'field_border_color' );

				$data['form_data']['payment_methods_heading']     = WFACP_Common::get_option( $section_key . '_section_payment_methods_heading' );
				$data['form_data']['payment_methods_sub_heading'] = WFACP_Common::get_option( $section_key . '_section_payment_methods_sub_heading' );


				if ( is_array( $data['border']['form_head'] ) && count( $data['border']['form_head'] ) > 0 ) {
					foreach ( $data['border']['form_head'] as $key1 => $value1 ) {

						$unit = 'px';
						if ( $key1 == 'border-color' || $key1 == 'border-style' ) {
							$unit = '';
						}


						$this->customizer_css['desktop']['.wfacp_main_form .wfacp-comm-title'][ $key1 ] = $value1 . $unit;

					}
				}


				if ( is_array( $data['border']['form_field_style'] ) && count( $data['border']['form_field_style'] ) > 0 ) {
					foreach ( $data['border']['form_field_style'] as $key1 => $value1 ) {

						$unit = 'px';
						if ( $key1 == 'border-color' || $key1 == 'border-style' ) {
							$unit = '';
						}

						$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper select.wfacp-form-control'][ $key1 ]                       = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control'][ $key1 ]                             = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control-wrapper input'][ $key1 ]               = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .woocommerce-input-wrapper .wfacp-form-control-wrapper select'][ $key1 ]              = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form select'][ $key1 ]                                                                     = $value1 . $unit;
						$this->customizer_css['desktop']['#et-boc .et-l span.select2-selection.select2-selection--multiple'][ $key1 ]                                 = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .select2-container .select2-selection--single .select2-selection__rendered'][ $key1 ] = $value1 . $unit . " !important";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:focus'][ $key1 ]            = $value1 . $unit . " !important";


						$this->customizer_css['desktop']['body .wfacp_main_form .wfacp_allowed_countries strong'][ $key1 ] = $value1 . $unit;

						$this->customizer_css['desktop']['body .wfacp_main_form select.wfacp-form-control'][ $key1 ] = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .wfacp-form-control'][ $key1 ]       = $value1 . $unit;

						$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="text"]'][ $key1 ]     = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="email"]'][ $key1 ]    = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row input[type="password"]'][ $key1 ] = $value1 . $unit;
						$this->customizer_css['desktop']['body .wfacp_main_form .wc-amazon-payments-advanced-populated .create-account p.form-row select'][ $key1 ]                 = $value1 . $unit;

						if ( $key1 !== 'border-color' ) {

							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-email) input[type=email]:hover'][ $key1 ]                                                                   = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=password]:hover'][ $key1 ]                                                       = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=search]:hover'][ $key1 ]                                                         = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=tel]:hover'][ $key1 ]                                                            = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=text]:hover'][ $key1 ]                                                           = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=url]:hover'][ $key1 ]                                                            = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) textarea:hover'][ $key1 ]                                                                   = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:hover'][ $key1 ]                                                                     = $value1 . $unit;
							$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .select2-container .select2-selection--single .select2-selection__rendered:hover'][ $key1 ] = $value1 . $unit . " !important";
						}
					}
				}

				/* Set data on global Field */
				$this->customizer_fields_data['wfacp_form'] = $data;


				/*  Color field*/
				$data_keys = $this->get_section_keys_data( 'wfacp_form' );

				if ( ! is_array( $data_keys ) || count( $data_keys ) == 0 ) {
					$data_keys = [];
					$data_keys = $this->get_color_keys();
				}

				$form_color_meta = [
					'panel'    => $section_key,
					'section'  => 'section',
					'template' => $selected_template_slug,
					'key'      => 'colors',
				];
				$this->assign_colors( $data_keys, $form_color_meta );

				/* add button styling */
				$num_of_steps = $this->get_step_count();

				$bread_crumb_count = $num_of_steps + 1;

				if ( $bread_crumb_count > 1 ) {
					$steps_text = [];
					for ( $bi = 0; $bi < $bread_crumb_count; $bi ++ ) {
						$step_text_here = WFACP_Common::get_option( $section_key . '_section_breadcrumb_' . $bi . '_step_text' );

						if ( isset( $step_text_here ) && $step_text_here != '' ) {
							$steps_text[] = $step_text_here;
							unset( $step_text_here );
						}
					}

					if ( is_array( $steps_text ) && count( $steps_text ) > 0 ) {
						$this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb'] = $steps_text;
					}
				}
				if ( $num_of_steps > 1 ) {

					$_enable_cart_in_breadcrumb = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . "_enable_cart_in_breadcrumb" );
					$cart_text                  = WFACP_Common::get_option( $section_key . '_section_cart_text' );

					$this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb_before'] = [
						'enable_cart'      => $_enable_cart_in_breadcrumb,
						'enable_cart_text' => $cart_text,
					];

				}

				$step_btns = [ 'order-place' ];

				if ( $num_of_steps > 1 ) {
					$text        = 'next';
					$step_btns[] = $text;

				}

				$btn_arr = [];
				foreach ( $step_btns as $skey => $svalue ) {
					$st_id = '';

					$btn_text[ $svalue ] = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_btn_text' );


					if ( isset( $btn_text['next'] ) && $btn_text['next'] != '' ) {
						$btn_text['back'] = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_back_btn_text' );

					}

					$btn_class_key        = 'button';
					$btn_parent_class_key = 'wfacp-' . $svalue . '-btn-wrap';
					if ( $svalue == 'order-place' ) {
						$st_id = '#place_order';
					} elseif ( $svalue == 'next' ) {
						$svalue = 'order-place';
					}


					$btn_class = 'body .wfacp_main_form .woocommerce-checkout button.' . $btn_class_key . $st_id;


					$width                        = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_width' );
					$btn_talign                   = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_talign' );
					$btn_font_weight              = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_btn_font_weight' );
					$make_button_sticky_on_mobile = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_make_button_sticky_on_mobile' );
					$btn_fs                       = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_fs' );
					$btn_top_bottom_padding       = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_top_bottom_padding' );
					$left_right_padding           = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_left_right_padding' );
					$border_radius                = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . '_btn_' . $svalue . '_border_radius' );


					$btn_arr = [
						'btn_text'                     => $btn_text,
						'width'                        => $width,
						'talign'                       => $btn_talign,
						'btn_font_weight'              => $btn_font_weight,
						'make_button_sticky_on_mobile' => $make_button_sticky_on_mobile,
						'fs'                           => $btn_fs,
						'top_bottom_padding'           => $btn_top_bottom_padding,
						'left_right_padding'           => $left_right_padding,
						'border_radius'                => $border_radius,

					];


					$this->customizer_css['desktop'][ 'body .wfacp_main_form .woocommerce-checkout .' . $btn_parent_class_key ]['text-align'] = $btn_talign;

					$this->customizer_css['desktop'][ $btn_class ]['padding-top']    = $btn_top_bottom_padding . 'px';
					$this->customizer_css['desktop'][ $btn_class ]['padding-bottom'] = $btn_top_bottom_padding . 'px';
					$this->customizer_css['desktop'][ $btn_class ]['font-weight']    = $btn_font_weight;

					$this->customizer_css['desktop'][ $btn_class ]['padding-left']  = $left_right_padding . 'px';
					$this->customizer_css['desktop'][ $btn_class ]['padding-right'] = $left_right_padding . 'px';
					$this->customizer_css['desktop'][ $btn_class ]['border-radius'] = $border_radius . 'px';

					$this->customizer_css['desktop'][ $btn_class ]['width'] = $width;

					if ( isset( $data['form_data']['field_style']['focus_color'] ) ) {
						$field_focus_color = $data['form_data']['field_style']['focus_color'];

						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-email) input[type=email]:focus']['box-shadow']             = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=password]:focus']['box-shadow'] = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=search]:focus']['box-shadow']   = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=tel]:focus']['box-shadow']      = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=text]:focus']['box-shadow']     = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=number]:focus']['box-shadow']   = "0 0 0 1px $field_focus_color";

						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=url]:focus']['box-shadow'] = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) textarea:focus']['box-shadow']        = "0 0 0 1px $field_focus_color";

						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:focus']['box-shadow']                                                                     = "0 0 0 1px $field_focus_color";
						$this->customizer_css['desktop']['body .wfacp-right-panel #coupon_code:focus']['box-shadow']                                                                                                                = "0 0 0 1px $field_focus_color !important";
						$this->customizer_css['desktop']['form.checkout_coupon.woocommerce-form-coupon .wfacp-col-left-half input:focus']['border-color']                                                                           = "$field_focus_color !important;";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus']['border-color'] = "$field_focus_color !important;";

						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus > span.select2-selection__rendered']['border-color'] = "$field_focus_color !important;";
						$this->customizer_css['desktop']['body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus']['box-shadow']                                      = "0 0 0 1px $field_focus_color !important";


					}

					if ( $width == 'initial' ) {
						$this->customizer_css['desktop']["_:-ms-fullscreen, :root body .wfacp_main_form .woocommerce-checkout .button.button"]['width'] = "auto !important";
					}

					$align_pos = '';
					$font_weight_subs='';
					if ( isset( $data['heading_section']['heading_fs'] ) ) {

						$subscription_target = 'body .wfacp_main_form .ia_subscription_items h3';

						$this->wfacp_font_size( $data['heading_section'], array(
							'section_key' => $section_key,
							'target_to'   => $subscription_target,
							'source_from' => 'heading_fs',
						) );

						if ( isset( $data['heading_section']['heading_talign'] ) ) {
							if ( $data['heading_section']['heading_talign'] == 'wfacp-text-left' ) {
								$align_pos = 'left';
							} elseif ( $data['heading_section']['heading_talign'] == 'wfacp-text-right' ) {
								$align_pos = 'right';
							} else {
								$align_pos = 'center';
							}
						}

						if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
							if ( $data['heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
								$font_weight_subs = 'normal';
							} else {
								$font_weight_subs = 'bold';
							}
						}
						if ( ! is_null( $align_pos ) ) {
							$this->customizer_css['desktop'][ $subscription_target ]['text-align'] = $align_pos;
						}
						if ( ! is_null( $font_weight_subs ) ) {
							$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;
						}

					}

					if ( isset( $data['heading_section']['heading_fs'] ) ) {

						$subscription_target = 'body .wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3';

						$this->wfacp_font_size( $data['heading_section'], array(
							'section_key' => $section_key,
							'target_to'   => $subscription_target,
							'source_from' => 'heading_fs',
						) );

						if ( isset( $data['heading_section']['heading_talign'] ) ) {
							if ( $data['heading_section']['heading_talign'] == 'wfacp-text-left' ) {
								$align_pos = 'left';
							} elseif ( $data['heading_section']['heading_talign'] == 'wfacp-text-right' ) {
								$align_pos = 'right';
							} else {
								$align_pos = 'center';
							}
						}

						if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
							if ( $data['heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
								$font_weight_subs = 'normal';
							} else {
								$font_weight_subs = 'bold';
							}
						}
						if ( ! is_null( $align_pos ) ) {
							$this->customizer_css['desktop'][ $subscription_target ]['text-align'] = $align_pos;
						}
						if ( ! is_null( $font_weight_subs ) ) {
							$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;
						}

					}

					if ( isset( $data['sub_heading_section']['heading_fs'] ) ) {

						$subscription_target = 'body .wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3 + p';

						$this->wfacp_font_size( $data['sub_heading_section'], array(
							'section_key' => $section_key,
							'target_to'   => $subscription_target,
							'source_from' => 'heading_fs',
						) );

						if ( isset( $data['sub_heading_section']['heading_talign'] ) ) {
							if ( $data['sub_heading_section']['heading_talign'] == 'wfacp-text-left' ) {
								$align_pos = 'left';
							} elseif ( $data['sub_heading_section']['heading_talign'] == 'wfacp-text-right' ) {
								$align_pos = 'right';
							} else {
								$align_pos = 'center';
							}
						}

						if ( isset( $data['sub_heading_section']['heading_font_weight'] ) ) {
							if ( $data['sub_heading_section']['heading_font_weight'] == 'wfacp-normal' ) {
								$font_weight_subs = 'normal';
							} else {
								$font_weight_subs = 'bold';
							}
						}

						$this->customizer_css['desktop'][ $subscription_target ]['text-align']  = $align_pos;
						$this->customizer_css['desktop'][ $subscription_target ]['font-weight'] = $font_weight_subs;

					}

					$this->wfacp_font_size( $btn_arr, array(
						'section_key' => $section_key,
						'target_to'   => $btn_class,
						'source_from' => 'fs',
					) );

				}

				$this->customizer_fields_data['wfacp_form']['form_data']['btn_details'] = $btn_arr;

				$this->prepare_dynamic_style( $data, 'wfacp_main_form' );


				/* Set Font Size */
				$this->wfacp_font_size( $data['form_data'], array(
					'section_key' => $section_key,
					'target_to'   => '.wfacp_main_form label.wfacp-form-control-label',
					'source_from' => 'field_style',
				) );
				$this->wfacp_font_size( $data['sub_heading_section'], array(
					'section_key' => $section_key,
					'target_to'   => '.wfacp_main_form .wfacp-comm-title h4',
					'source_from' => 'heading_fs',
				) );

			}
		}
	}

	protected function get_field_css_ready( $template_slug, $field_index ) {
		$main_class = WFACP_Common::get_option( 'wfacp_form_form_fields_1_' . $template_slug . '_' . $field_index );
		if ( '' !== trim( $main_class ) ) {
			$main_class .= ' ' . WFACP_Common::get_option( 'wfacp_form_form_fields_1_' . $template_slug . '_' . $field_index . '_other_classes' );
		}

		return $main_class;
	}

	public function change_default_setting( $panel_details, $panel_key ) {
		$fields_data = $panel_details['sections']['section']['fields'];


		foreach ( $fields_data as $key => $value ) {
			if ( isset( $this->layout_setting[ $panel_key ][ $key ] ) ) {
				$panel_details['sections']['section']['fields'][ $key ]['default'] = $this->layout_setting[ $panel_key ][ $key ];
			}
		}

		return $panel_details;
	}

	public function order_btn_sticky( $panel_details, $panel_key ) {
		$selected_template_slug = $this->template_slug;
		if ( $panel_key == 'wfacp_form' ) {

			$pageID         = WFACP_Common::get_id();
			$_wfacp_version = WFACP_Common::get_post_meta_data( $pageID, '_wfacp_version' );

			if ( isset( $_wfacp_version ) && ! empty( $_wfacp_version ) ) {
				if ( isset( $panel_details['sections']['section']['fields'][ $selected_template_slug . '_btn_order-place_make_button_sticky_on_mobile' ] ) ) {
					$panel_details['sections']['section']['fields'][ $selected_template_slug . '_btn_order-place_make_button_sticky_on_mobile' ]['default'] = 'no_sticky';

				}
			}
		}

		return $panel_details;
	}

	public function multi_tab_default_setting( $panel_details, $panel_key ) {

		if ( empty( $panel_key ) || empty( $this->layout_setting ) ) {
			return $panel_details;

		}

		foreach ( $panel_key as $index_key => $value ) {
			if ( empty( $value ) ) {
				continue;
			}
			if ( ! isset( $this->layout_setting[ $index_key ] ) ) {
				continue;
			}
			foreach ( $value as $pkey => $pvalue ) {
				$fields_data = $panel_details['sections'][ $pvalue ]['fields'];
				if ( empty( $pvalue ) ) {
					continue;
				}
				foreach ( $fields_data as $key => $value ) {
					if ( array_key_exists( $key, $this->layout_setting[ $index_key ] ) ) {
						$panel_details['sections'][ $pvalue ]['fields'][ $key ]['default'] = $this->layout_setting[ $index_key ][ $key ];
					}
				}
			}
		}

		return $panel_details;
	}

	public function get_heading_section( $section_key, $selected_template_slug = '' ) {

		if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
			$selected_template_slug = $selected_template_slug . '_';
		} else {
			$selected_template_slug = '';
		}

		$heading_section = array();

		$enable_heading      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'enable_heading' );
		$heading             = WFACP_Common::get_option( $section_key . '_section_heading' );
		$heading_font_size   = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_fs' );
		$heading_talign      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_talign' );
		$heading_font_weight = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'heading_font_weight' );

		if ( isset( $enable_heading ) ) {
			$heading_section['enable_heading'] = $enable_heading;
		}
		if ( isset( $heading ) ) {
			$heading_section['heading'] = $heading;
		}
		if ( isset( $heading_font_size ) ) {
			$heading_section['heading_fs'] = $heading_font_size;
		}
		if ( isset( $heading_talign ) ) {
			$heading_section['heading_talign'] = $heading_talign;
		}

		if ( isset( $heading_font_weight ) ) {
			$heading_section['heading_font_weight'] = $heading_font_weight;
		}

		$heading_section = WFACP_Common::unset_blank_keys( $heading_section );

		return $heading_section;
	}

	public function get_advance_setting( $section_key, $selected_template_slug = '', $is_mult_tab = false ) {

		if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
			$selected_template_slug = $selected_template_slug . '_';
		} else {
			$selected_template_slug = '';
		}

		$section_inner_key = "_section_";
		if ( true === $is_mult_tab ) {


			$section_inner_key = "_";
		}

		$advanced_setting                      = array();
		$advanced_setting['rbox_border_type']  = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_type' );
		$advanced_setting['rbox_border_width'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_width' );
		$advanced_setting['rbox_border_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_border_color' );
		$advanced_setting['rbox_padding']      = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'rbox_padding' );

		$advanced_setting = WFACP_Common::unset_blank_keys( $advanced_setting );

		return $advanced_setting;
	}

	public function get_color_setting( $section_key, $selected_template_slug = '', $is_mult_tab = false ) {
		$color_setting = array();

		if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
			$selected_template_slug = $selected_template_slug . '_';
		} else {
			$selected_template_slug = '';
		}

		$section_inner_key = "_section_";
		if ( true === $is_mult_tab ) {
			$section_inner_key = "_";
		}


		$color_setting['section_bg_color']   = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'section_bg_color' );
		$color_setting['sec_heading_color']  = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'sec_heading_color' );
		$color_setting['heading_text_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'heading_text_color' );
		$color_setting['content_text_color'] = WFACP_Common::get_option( $section_key . $section_inner_key . $selected_template_slug . 'content_text_color' );

		$color_setting = WFACP_Common::unset_blank_keys( $color_setting );

		return $color_setting;
	}

	public function prepare_dynamic_style( $data, $section_key ) {

		/* Heading Setting Start */


		/* Font Size */
		if ( isset( $data['heading_section']['heading_fs'] ) ) {

			$heading_fs   = $data['heading_section']['heading_fs'];
			$default_unit = '';

			$desktop_fs = '';

			/* Desktop Font Size  */
			if ( isset( $heading_fs['desktop'] ) ) {
				$desktop_fs = $heading_fs['desktop'];
			}
			if ( isset( $heading_fs['desktop-unit'] ) ) {
				$default_unit = $heading_fs['desktop-unit'];
			}
			$desktop_font_size = $desktop_fs . $default_unit;

			$tablet_font_size = '';
			$tablet_fs        = '';

			/* Tablet Font Size  */
			if ( isset( $heading_fs['tablet'] ) && $heading_fs['tablet'] != '' ) {
				$tablet_fs = $heading_fs['tablet'];
			}
			if ( isset( $heading_fs['tablet-unit'] ) && $heading_fs['tablet-unit'] != '' ) {
				$default_unit = $heading_fs['tablet-unit'];
			}
			$tablet_font_size = $tablet_fs . $default_unit;

			/* Mobile Font Size  */
			$mobile_font_size = '';
			$mobile_fs        = '';

			if ( isset( $heading_fs['mobile'] ) && $heading_fs['mobile'] != '' ) {
				$mobile_fs = $heading_fs['mobile'];
			}
			if ( isset( $heading_fs['mobile-unit'] ) && $heading_fs['mobile-unit'] != '' ) {
				$default_unit = $heading_fs['mobile-unit'];
			}
			$mobile_font_size = $mobile_fs . $default_unit;

			if ( $desktop_font_size != '' ) {
				$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $desktop_font_size ];
			}

			if ( $tablet_font_size != '' ) {
				$this->customizer_css['tablet'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $tablet_font_size ];
			}
			if ( $mobile_font_size != '' ) {
				$this->customizer_css['mobile'][ '.' . $section_key . ' .wfacp_section_title' ] = [ 'font-size' => $mobile_font_size ];
			}

		}

		/* Text Alignment */
		$align_position = 'center';
		if ( isset( $data['heading_section']['heading_talign'] ) ) {
			$heading_talign = $data['heading_section']['heading_talign'];
			if ( $heading_talign == 'wfacp-text-center' ) {
				$align_position = 'center';
			} elseif ( $heading_talign == 'wfacp-text-left' ) {
				$align_position = 'left';
			} elseif ( $heading_talign == 'wfacp-text-right' ) {
				$align_position = 'right';
			}
			$this->customizer_css['desktop'][ '.' . $section_key . " .wfacp-text-$align_position" ] = array(
				'text-align' => $align_position,
			);
		}

		/* Font  Weight */
		if ( isset( $data['heading_section']['heading_font_weight'] ) ) {
			$font_weight = $data['heading_section']['heading_font_weight'];
			if ( $font_weight == 'wfacp-normal' ) {
				$weight_size = 'normal';
			} elseif ( $font_weight == 'wfacp-bold' ) {
				$weight_size = 'bold';
			}
			$this->customizer_css['desktop'][ '.' . $section_key . " .wfacp-$weight_size" ] = array(
				'font-weight' => $weight_size,
			);
		}

		/* Advanced Setting Start*/
		$additional_setting = array();


		$rbox_border_type = '';
		if ( isset( $data['advance_setting']['rbox_border_type'] ) ) {
			$rbox_border_type                   = $data['advance_setting']['rbox_border_type'];
			$additional_setting['border-style'] = $rbox_border_type;

		}
		if ( isset( $data['advance_setting']['rbox_border_width'] ) ) {
			$rbox_border_width                  = $data['advance_setting']['rbox_border_width'];
			$additional_setting['border-width'] = $rbox_border_width . 'px';
		}
		if ( isset( $data['advance_setting']['rbox_border_color'] ) ) {
			$rbox_border_color                  = $data['advance_setting']['rbox_border_color'];
			$additional_setting['border-color'] = $rbox_border_color;
		}
		if ( isset( $data['advance_setting']['rbox_padding'] ) ) {
			$rbox_padding = $data['advance_setting']['rbox_padding'];

			$additional_setting['padding'] = $rbox_padding . 'px';
		}
		/* Advanced Setting Closed */

		/* Color Setting Start */
		if ( isset( $data['colors']['section_bg_color'] ) ) {
			$section_bg_color = $data['colors']['section_bg_color'];

			$additional_setting['background-color'] = $section_bg_color;
		}


		if ( isset( $data['colors']['sec_heading_color'] ) ) {
			$sec_heading_color                                                                = $data['colors']['sec_heading_color'];
			$this->customizer_css['desktop'][ '.' . $section_key . ' .wfacp_section_title ' ] = array(
				'color' => $sec_heading_color,
			);
		}

		if ( isset( $data['colors']['content_text_color'] ) ) {
			$content_text_color                                            = $data['colors']['content_text_color'];
			$this->customizer_css['desktop'][ '.' . $section_key . ' p ' ] = array(
				'color' => $content_text_color,
			);
		}
		if ( ( is_array( $additional_setting ) && count( $additional_setting ) > 0 ) ) {
			$this->customizer_css['desktop'][ '.' . $section_key ] = $additional_setting;

		}

	}

	public function get_sub_heading_section( $section_key, $selected_template_slug = '' ) {


		if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
			$selected_template_slug = $selected_template_slug . '_';
		} else {
			$selected_template_slug = '';
		}

		$heading_section = array();

		$enable_sub_heading      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'enable_sub_heading' );
		$sub_heading             = WFACP_Common::get_option( $section_key . '_section_sub_heading' );
		$sub_heading_fs          = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_fs' );
		$sub_heading_talign      = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_talign' );
		$sub_heading_font_weight = WFACP_Common::get_option( $section_key . '_section_' . $selected_template_slug . 'sub_heading_font_weight' );

		if ( isset( $enable_sub_heading ) && $enable_sub_heading != '' ) {
			$heading_section['enable_heading'] = $enable_sub_heading;
		}
		if ( isset( $sub_heading ) && $sub_heading != '' ) {
			$heading_section['heading'] = $sub_heading;
		}
		if ( isset( $sub_heading_fs ) && $sub_heading_fs != '' ) {
			$heading_section['heading_fs'] = $sub_heading_fs;
		}

		if ( isset( $sub_heading_talign ) && $sub_heading_talign != '' ) {
			$heading_section['heading_talign'] = $sub_heading_talign;
		}

		if ( isset( $sub_heading_font_weight ) && $sub_heading_font_weight != '' ) {
			$heading_section['heading_font_weight'] = $sub_heading_font_weight;
		}


		$heading_section = WFACP_Common::unset_blank_keys( $heading_section );

		return $heading_section;
	}

	public function get_section_keys_data( $section_key ) {
		if ( isset( $this->section_keys_data[ $section_key ] ) ) {
			return $this->section_keys_data[ $section_key ];
		}

		return $section_key;
	}

	public function set_section_keys_data( $section_key, $data ) {
		$this->section_keys_data[ $section_key ] = $data;
	}

	public function assign_colors( $data_keys, $form_color_meta = [] ) {
		$prefix_key = '';
		$panel_name = '';

		if ( isset( $form_color_meta['panel'] ) && $form_color_meta['panel'] != '' ) {
			$prefix_key = $prefix_key . $form_color_meta['panel'] . '_';
			$panel_name = $form_color_meta['panel'];
		}

		if ( isset( $form_color_meta['section'] ) && $form_color_meta['section'] != '' ) {
			$prefix_key = $prefix_key . $form_color_meta['section'] . '_';
		}

		$data = [];
		if ( ! is_array( $data_keys ) || count( $data_keys ) == 0 || $prefix_key == '' ) {
			return;
		}


		$local_css = [];
		$temp_type = $this->get_template_type();


		foreach ( $data_keys['colors'] as $key => $details ) {

			$key_name = $key;

			$important_to_class = '';


			if ( $panel_name == 'wfacp_form' && strpos( $key, '_next_' ) !== false ) {
				$key_name = str_replace( '_next_', '_order-place_', $key );
			}

			$data[ $form_color_meta['key'] ][ $key ] = WFACP_Common::get_option( $prefix_key . $key_name );

			if ( ! isset( $data[ $form_color_meta['key'] ][ $key ] ) || $data[ $form_color_meta['key'] ][ $key ] == '' ) {
				continue;
			}

			foreach ( $details as $index => $value ) {
				$device      = $value['device'];
				$class       = $value['class'];
				$type        = $value['type'];
				$field_value = $data[ $form_color_meta['key'] ][ $key ];

				if ( isset( $device ) && isset( $class ) && isset( $type ) && isset( $field_value ) ) {

					if ( $temp_type == 'embed_form' && defined( 'ET_CORE_VERSION' ) ) {
						if ( strpos( $key_name, 'btn_order-place' ) !== false && ( $type == 'background-color' || $type == 'color' ) ) {

							$important_to_class = ' !important';
						}
					}


					$this->customizer_css[ $device ][ $class ][ $type ] = $field_value . $important_to_class;

					$local_css[ $device ][ $class ][ $type ] = $field_value . $important_to_class;
				}
			}
		}

		if ( $panel_name == '' ) {
			return;
		}

		foreach ( $data as $key => $value ) {
			$this->customizer_fields_data[ $panel_name ][ $key ] = $value;
		}

	}

	public function wfacp_font_size( $data, $metaData ) {

		extract( $metaData );

		if ( ! isset( $section_key ) || ! isset( $target_to ) || ! isset( $source_from ) ) {
			return;
		}
		$font_size = 16;
		if ( isset( $data[ $source_from ] ) ) {
			if ( is_array( $data[ $source_from ] ) && count( $data[ $source_from ] ) > 0 && isset( $data[ $source_from ]['desktop'] ) ) {
				$font_size = $data[ $source_from ]['desktop'];
			}else{
				$font_size = $data[ $source_from ];
            }


		}


		$desktop_fs   = '';
		$tablet_fs    = '';
		$mobile_fs    = '';
		$default_unit = 'px';


		$heading_fs = [
			'desktop'      => $font_size,
			'tablet'       => $font_size,
			'mobile'       => $font_size,
			'desktop-unit' => 'px',
			'tablet-unit'  => 'px',
			'mobile-unit'  => 'px',
		];


		/* Desktop Font Size  */
		if ( isset( $heading_fs['desktop'] ) ) {
			$desktop_fs = $heading_fs['desktop'];
		}
		if ( isset( $heading_fs['desktop-unit'] ) ) {
			$default_unit = $heading_fs['desktop-unit'];
		}

		$desktop_font_size = $desktop_fs . $default_unit;
		/* Tablet Font Size  */

		if ( isset( $heading_fs['tablet'] ) ) {
			$tablet_fs = $heading_fs['tablet'];
		}
		if ( isset( $heading_fs['tablet-unit'] ) ) {
			$default_unit = $heading_fs['tablet-unit'];
		}

		$tablet_font_size = $tablet_fs . $default_unit;

		/* Mobile Font Size  */

		if ( isset( $heading_fs['mobile'] ) ) {
			$mobile_fs = $heading_fs['mobile'];
		}

		if ( isset( $heading_fs['mobile-unit'] ) ) {
			$default_unit = $heading_fs['mobile-unit'];
		}
		$mobile_font_size = $mobile_fs . $default_unit;

		if ( isset( $this->customizer_css['desktop'][ $target_to ] ) && is_array( $this->customizer_css['desktop'][ $target_to ] ) && count( $this->customizer_css['desktop'][ $target_to ] ) > 0 ) {

			if ( isset( $desktop_font_size ) ) {
				$this->customizer_css['desktop'][ $target_to ]['font-size'] = $desktop_font_size;
			}

			if ( isset( $tablet_font_size ) ) {

				$this->customizer_css['tablet'][ $target_to ]['font-size'] = $tablet_font_size;

			}
			if ( isset( $mobile_font_size ) ) {
				$this->customizer_css['mobile'][ $target_to ]['font-size'] = $mobile_font_size;
			}
		} else {

			if ( isset( $desktop_font_size ) ) {
				$this->customizer_css['desktop'][ $target_to ] = array(
					'font-size' => $desktop_font_size,
				);

			}
			if ( isset( $tablet_font_size ) ) {
				$this->customizer_css['tablet'][ $target_to ] = array(
					'font-size' => $tablet_font_size,
				);
			}
			if ( isset( $mobile_font_size ) ) {
				$this->customizer_css['mobile'][ $target_to ] = array(
					'font-size' => $mobile_font_size,
				);
			}
		}

	}

	public function get_customizer_data() {
		return;
	}

	public function get_sections() {
		return $this->sections;
	}

	public function get_section( $wp_customize = false ) {
		/** WFACPKirki is required to customizer */
		if ( ! class_exists( 'WFACPKirki' ) ) {
			return;
		}

		if ( false == $wp_customize ) {
			return;
		}

		if ( ! is_array( $this->customizer_data ) || count( $this->customizer_data ) == 0 ) {
			return;
		}

		foreach ( $this->customizer_data as $panel_single ) {
			foreach ( $panel_single as $panel_key => $panel_arr ) {
				/** Panel */
				$maybe_panel = true;
				if ( isset( $panel_arr['panel'] ) && 'no' == $panel_arr['panel'] ) {
					/** No need to register panel */
					$maybe_panel = false;
				} else {
					$arr = $panel_arr['data'];
					$arr = array_merge( $arr, array(
						'capability'     => 'edit_theme_options',
						'theme_supports' => '',
					) );
					$wp_customize->add_panel( $panel_key, $arr );
				}

				if ( ! is_array( $panel_arr['sections'] ) || count( $panel_arr['sections'] ) == 0 ) {
					continue;
				}

				/** Section */

				foreach ( $panel_arr['sections'] as $section_key => $section_arr ) {
					$section_key_final = $panel_key . '_' . $section_key;

					$this->sections[] = $section_key_final;

					if ( isset( $section_arr['data'] ) ) {
						$arr = $section_arr['data'];
					}

					if ( true === $maybe_panel ) {
						$arr = array_merge( $arr, array(
							'panel' => $panel_key,
						) );
					}

					$wp_customize->add_section( $section_key_final, $arr );

					/** Fields - will add using wfacpkirki */

					/** Set the selective part */
					if ( ! is_array( $section_arr['fields'] ) || count( $section_arr['fields'] ) == 0 ) {
						continue;
					}

					foreach ( $section_arr['fields'] as $field_key => $field_data ) {
						$field_key_final = $section_key_final . '_' . $field_key;
						$field_key_final = WFACP_Core()->customizer->customizer_key_prefix . '[' . $field_key_final . ']';

						/** Checking if wfacp_partial class exist */
						if ( ! isset( $field_data['wfacp_partial'] ) || ! is_array( $field_data['wfacp_partial'] ) || ! isset( $field_data['wfacp_partial']['elem'] ) ) {
							continue;
						}

						$callback = isset( $field_data['wfacp_partial']['callback'] ) ? $field_data['wfacp_partial']['callback'] : 'render_callback';

						$wp_customize->selective_refresh->add_partial( $field_key_final, array(
							'selector'        => $field_data['wfacp_partial']['elem'],
							'render_callback' => array( $this, $callback ),
							'primary_setting' => $field_key_final,
						) );

					}
				}
			}
		}
	}

	public function render_callback( $data ) {
		$partial_key_base = $data->id_data();
		if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
			$partial_key         = $partial_key_base['keys'][0];
			switch ( $partial_key ) {
				case 'wfacp_header_top_logo':
					$logo = WFACP_Common::get_option( $partial_key );
					$no_logo_img = WFACP_PLUGIN_URL . '/admin/assets/img/no_logo.jpg';
					?>
                    <img src="<?php echo $logo ? $logo : $no_logo_img; ?>" alt="<?php bloginfo( 'name' ); ?>"
                         title="<?php bloginfo( 'name' ); ?>"/>
					<?php
					$logo_img_html = ob_get_clean();

					return $logo_img_html;
					break;
				default:
					$value = WFACP_Common::get_option( $partial_key );
					if ( ! empty( $value ) ) {
						$value = nl2br( $value );
					}

					return $value;
					break;
			}
		}
	}

	public function wfacp_header_logo( $data ) {
		$partial_key_base = $data->id_data();

		if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
			$partial_key = $partial_key_base['keys'][0];
			$logo        = WFACP_Common::get_option( $partial_key );
			$no_logo_img = $this->img_path . 'woo_checkout_logo.png';

			ob_start();
			?>


            <img class="wfacp-logo" src="<?php echo $logo ? $logo : $no_logo_img; ?>" alt="<?php the_title() ?>">


			<?php
			$wfacp_header_logo = ob_get_clean();

			return $wfacp_header_logo;
		}
	}

	public function wfacp_changed_step_text( $data ) {
		$partial_key_base = $data->id_data();

		if ( is_array( $partial_key_base ) && isset( $partial_key_base['keys'] ) ) {
			$partial_key     = $partial_key_base['keys'][0];
			$step_value_text = WFACP_Common::get_option( $partial_key );
			$text_class_nner = ( ! empty( $step_value_text ) ) ? 'wfacp_step_text_have' : 'wfacp_step_text_nohave';

			ob_start();
			?>
            <a href='javascript:void(0)' class="<?php echo $text_class_nner; ?>"><?php echo $step_value_text; ?></a>
			<?php
			$step_value_text_html = ob_get_clean();

			return $step_value_text_html;
		}
	}

	public function form_pop_up_content() {
		?>

        <div id="wfacp_form_popup_content" style="display: none;">

            <h3>
				<?php _e( 'CSS Ready Classes', 'woofunnels-aero-checkout' ); ?>
            </h3>
            <div class="wfacp_des_wrap">
				<?php _e( 'Here are set of CSS classes that can be used to style the checkout form', 'woofunnels-aero-checkout' ); ?>

            </div>


            <table class="table widefat">
                <thead>
                <tr>
                    <td><?php _e( 'Title', 'woofunnels-aero-checkout' ); ?></td>
                    <td style="width: 70%;">
						<?php _e( 'Classes', 'woofunnels-aero-checkout' ); ?>
                    </td>

                </tr>
                </thead>
                <tbody>

                <tr>
                    <td><?php _e( 'To create full width field', 'woofunnels-aero-checkout' ); ?></td>
                    <td><input type="text" readonly onClick="this.select()" value='wfacp-col-full'/></td>
                </tr>

                <tr>
                    <td><?php _e( 'To create two columns structure and set field left side', 'woofunnels-aero-checkout' ); ?></td>
                    <td><input type="text" readonly onClick="this.select()" value='wfacp-col-left-half'/></td>
                </tr>

                <tr>
                    <td><?php _e( 'To create three columns structure and set field left side', 'woofunnels-aero-checkout' ); ?></td>
                    <td><input type="text" readonly onClick="this.select()" value='wfacp-col-left-third'/></td>
                </tr>


                <tr>
                    <td><?php _e( 'To create two third columns structure', 'woofunnels-aero-checkout' ); ?></td>
                    <td><input type="text" readonly onClick="this.select()" value='wfacp-col-two-third'/></td>
                </tr>
                <tr>
                    <td><?php _e( 'To create field from new line use clearfix', 'woofunnels-aero-checkout' ); ?></td>
                    <td><input type="text" readonly onClick="this.select()" value='wfacp-col-clearfix'/></td>
                </tr>


                </tbody>


            </table>

        </div>

		<?php
	}

	public function get_excluded_sidebar_sections() {
		return $this->excluded_sidebar_sections;
	}

	public function active_sidebar() {
		return $this->current_active_sidebar = WFACP_Common::get_option( 'wfacp_layout_section_' . $this->template_slug . '_sidebar_layout_order' );
	}

	public function excluded_other_widget() {

		$other_layout_widget = WFACP_Common::get_option( 'wfacp_layout_section_' . $this->template_slug . '_other_layout_widget' );

		$tempArr = [];
		if ( is_array( $other_layout_widget ) && count( $other_layout_widget ) > 0 ) {
			$this->current_active_sidebar = $other_layout_widget;
			$tempArr                      = $this->current_active_sidebar;
		}

		return $tempArr;
	}

	final public function get_module( $data, $return, $type, $section_key ) {

		$file_path = WFACP_TEMPLATE_MODULE_DIR;
		if ( 'wfacp_html_widget' === $type ) {
			$file_path = WFACP_TEMPLATE_COMMON . '/template-parts/sections';
		}
		if ( ! $return && ( $type != '' ) ) {

			if ( file_exists( $file_path . '/' . $type . '.php' ) ) {
				include( $file_path . '/' . $type . '.php' );
			}
		}

	}

	public function add_class_change_place_order( $btn_html ) {

		$stepCount         = $this->get_step_count();
		$get_template_slug = $this->get_template_slug();
		$get_template_type = $this->get_template_type();


		if ( ! empty( $_GET['woo-paypal-return'] ) && ! empty( $_GET['token'] ) && ! empty( $_GET['PayerID'] ) ) {
			return $btn_html;
		}


		$alignmentclass = '';
		$width_cls      = '';

		if ( $stepCount > 1 ) {
			$alignmentclass = WFACP_Common::get_option( 'wfacp_form_section_' . $get_template_slug . '_btn_order-place_talign' );
			$width_cls1     = WFACP_Common::get_option( 'wfacp_form_section_' . $get_template_slug . '_btn_order-place_width' );
			if ( 'initial' === $width_cls1 ) {
				$width_cls = $width_cls1;

			}

		}


		ob_start();

		echo sprintf( '<div class="wfacp-order-place-btn-wrap %s %s">', $alignmentclass, $width_cls );

		echo $btn_html;

		if ( $stepCount > 1 ) {
			$last_step = 'single_step';
			if ( $this->current_step == 'third_step' ) {
				$last_step = 'two_step';
			}

			$getKey = $stepCount - 2;

			$back_btn_text = WFACP_Common::get_option( 'wfacp_form_section_back_btn_text' );


			if ( '' === $back_btn_text && 'pre_built' === $get_template_type ) {
				$back_btn_text = '&laquo; Return to {step_name}';
			}

			if ( strpos( $back_btn_text, '{step_name}' ) !== false ) {
				if ( 'pre_built' === $get_template_type ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_breadcrumb_' . $getKey . '_step_text' ) );
				}

				if ( 'embed_forms_2' === $get_template_type || 'embed_form' === $get_template_type ) {
					$sectionKeyText = strtolower( WFACP_Common::get_option( 'wfacp_form_section_embed_forms_2_name_' . $getKey ) );

				}

				$back_btn_text = str_replace( "{step_name}", "$sectionKeyText", $back_btn_text );

			}
			$back_text = __( '&laquo; Return', 'woofunnels-aero-checkout' );

			if ( ! isset( $back_btn_text ) || $back_btn_text == '' ) {
				$back_btn_text = $back_text;
			}
			echo "<div class='place_order_back_btn wfacp_none_class '><a class='wfacp_back_page_button' data-next-step='" . $last_step . "' data-current-step='" . $this->current_step . "' href='javascript:void(0)'>" . __( $back_btn_text, 'woofunnels-aero-checkout' ) . '</a> </div>';
		}


		echo '</div>';

		$orderPlaceHtml = ob_get_clean();

		return $orderPlaceHtml;
	}

	public function change_order_placed_step_label( $order_button_text ) {

		$template_slug = $this->template_slug;

		$orderText = WFACP_Common::get_option( 'wfacp_form_section_' . $template_slug . '_btn_order-place_btn_text' );

		if ( isset( $orderText ) && $orderText != '' ) {
			return $orderText;
		}

		$text = strtoupper( $order_button_text );

		return $text;
	}

	public function payment_button_text() {
		return WFACP_Common::get_option( 'wfacp_form_section_' . $this->template_slug . '_btn_order-place_btn_text' );
	}

	public function call_before_cart_link( $breadcrumb ) {

		$is_global_checkout = WFACP_Core()->public->is_checkout_override();
		$before_link        = $this->customizer_fields_data['wfacp_form']['form_data']['breadcrumb_before'];
		if ( ! is_array( $before_link ) || count( $before_link ) == 0 ) {
			return;
		}

		if ( ( WFACP_Common::is_customizer() || $is_global_checkout === true ) ) {


			if ( isset( $before_link['enable_cart'] ) && $before_link['enable_cart'] == 1 ) {

				$slug         = $this->get_template_slug();
				$inline_width = '';


				$cartURL  = wc_get_cart_url();
				$cartName = __( $before_link['enable_cart_text'], 'woocommerce' );

				echo "<li class='df_cart_link wfacp_bred_visited' $inline_width><a href='$cartURL'>$cartName</a></li>";
			}
		}


	}

	function add_custom_cls( $body_class ) {

		$wfacp_id = $this->wfacp_id;
		if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'] ) ) {
			$wfacp_body_class[] = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'];
		}
		$is_default_checkout = get_post_meta( $wfacp_id, 'is_default_checkout', true );

		if ( ( isset( $is_default_checkout ) && $is_default_checkout == 1 ) ) {


			$body_class[] = 'wfacp_default_created';
		}


		return $body_class;

	}

	public function get_form_data() {

		$form_data = isset( $this->customizer_fields_data['wfacp_form'] ) ? $this->customizer_fields_data['wfacp_form'] : [];

		return $form_data;
	}

	public function get_heading_title_class() {
		$form_data = $this->get_form_data();
		if ( isset( $form_data['border']['form_head']['border-style'] ) && '' != $form_data['border']['form_head']['border-style'] ) {

			return trim( $form_data['border']['form_head']['border-style'] );
		}

		return '';
	}

	public function get_heading_class() {

		$heading_talign      = '';
		$heading_font_weight = '';
		$form_data           = $this->get_form_data();
		if ( isset( $form_data['heading_section']['heading_talign'] ) ) {
			$heading_talign = $form_data['heading_section']['heading_talign'];
		}

		if ( isset( $form_data['heading_section']['heading_font_weight'] ) ) {
			$heading_font_weight = $form_data['heading_section']['heading_font_weight'];
		}

		return $heading_font_weight . ' ' . $heading_talign;
	}

	public function get_sub_heading_class() {
		$sub_heading_talign      = '';
		$sub_heading_font_weight = '';
		$form_data               = isset( $this->customizer_fields_data['wfacp_form'] ) ? $this->customizer_fields_data['wfacp_form'] : [];
		if ( isset( $form_data['sub_heading_section']['heading_talign'] ) ) {
			$sub_heading_talign = $form_data['sub_heading_section']['heading_talign'];
		}
		if ( isset( $form_data['sub_heading_section']['heading_font_weight'] ) ) {
			$sub_heading_font_weight = $form_data['sub_heading_section']['heading_font_weight'];
		}

		return $sub_heading_talign . ' ' . $sub_heading_font_weight;

	}

	public function get_payment_desc() {
		$form_data = $this->get_form_data();
		if ( isset( $form_data['form_data']['text_below_placeorder_btn'] ) && $form_data['form_data']['text_below_placeorder_btn'] != '' ) {
			return trim( $form_data['form_data']['text_below_placeorder_btn'] );
		}

		return '';

	}

	public function payment_heading() {
		$form_data = $this->get_form_data();
		if ( isset( $form_data['form_data']['payment_methods_heading'] ) && $form_data['form_data']['payment_methods_heading'] != '' ) {
			return trim( $form_data['form_data']['payment_methods_heading'] );
		}

		return '';

	}

	public function payment_sub_heading() {
		$form_data = $this->get_form_data();
		if ( isset( $form_data['form_data']['payment_methods_sub_heading'] ) && $form_data['form_data']['payment_methods_sub_heading'] != '' ) {
			return trim( $form_data['form_data']['payment_methods_sub_heading'] );
		}

		return '';
	}

	public function payment_button_alignment() {
		$form_data = $this->get_form_data();
		if ( isset( $form_data['btn_details']['talign'] ) && '' !== $form_data['btn_details']['talign'] ) {
			return trim( $form_data['btn_details']['talign'] );
		}

		return parent::payment_button_alignment();
	}

	public function customizer_layout_order( $panel_details, $section_key ) {
		return $panel_details;
	}

	public function get_embed_localize_data() {
		$localData = [];
		if ( isset( $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'] ) ) {

			$make_button_sticky_on_mobile = $this->customizer_fields_data['wfacp_form']['form_data']['btn_details']['make_button_sticky_on_mobile'];

			if ( $make_button_sticky_on_mobile === 'yes_sticky' ) {
				$localData['wfacp_make_button_sticky_on_mobile'] = 'yes';
			}

		}
		wp_localize_script( 'wfacp_checkout_js', 'wfacp_elementor_data', $localData );
	}

	public function enable_show_img_order_summary( $status ) {

		$selected_template_slug = $this->get_template_slug();

		$layout_key = '';
		if ( isset( $selected_template_slug ) && $selected_template_slug != '' ) {
			$layout_key = $selected_template_slug . '_';
		}

		$order_hide_img = WFACP_Common::get_option( 'wfacp_order_summary_section_' . $layout_key . 'order_summary_hide_img' );

		$order_hide_img = isset( $order_hide_img ) ? $order_hide_img : false;

		if ( ( true === $order_hide_img || 1 === $order_hide_img ) && ! empty( $order_hide_img ) ) {

			return true;
		}


		return false;

	}

	public function print_empty_style_tag() {
		echo '<style data-type=\'wfacp\'></style>';
	}

	public function get_color_keys() {
		$selected_template_slug      = $this->get_template_slug();
		$section_data_keys['colors'] = [
			$selected_template_slug . '_sec_heading_color'             => [
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp_section_title',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .ia_subscription_items h3',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_sec_sub_heading_color'         => [
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp-comm-title h4',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form #woocommerce_eu_vat_compliance #woocommerce_eu_vat_compliance_vat_number h3 + p',
					'device' => 'desktop',
				],

			],
			$selected_template_slug . '_field_style_color'             => [
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form label.wfacp-form-control-label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp_custom_field_radio_wrap label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp_custom_field_cls span',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp_custom_field_cls label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form #vat_number-description',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form.woocommerce .wfacp_checkbox_field label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp-row .automatewoo-birthday-section > label',
					'device' => 'desktop',
				],

			],
			$selected_template_slug . '_validation_color'              => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-error',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-error li',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-error li strong',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_sec_bg_color'                  => [
				[
					'type'   => 'background-color',
					'class'  => '.wfacp_main_form .wfacp-comm-title',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_additional_bg_color'           => [
				[
					'type'   => 'background-color',
					'class'  => '.wfacp_main_form .wfacp-payment-dec',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_additional_text_color'         => [
				[
					'type'   => 'color',
					'class'  => '.wfacp_main_form .wfacp-payment-dec',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_breadcrumb_text_color'         => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_steps_sec ul li a',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_breadcrumb_text_hover_color'   => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_steps_sec ul li a:hover',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_order_total_bg_color'          => [
				[
					'type'   => 'background-color',
					'class'  => 'body .wfacp_main_form .wfacp_order_total_field table.wfacp_order_total_wrap',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_order_total_text_color'        => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .wfacp_order_total_field table.wfacp_order_total_wrap td',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_order_total_border_color'      => [
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form.woocommerce .wfacp_order_total_field table.wfacp_order_total_wrap',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_field_border_color'            => [
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .select2-container--default.select2-container--focus .select2-selection--multiple',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .select2-container--default .select2-selection--multiple',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => '#et-boc .et-l span.select2-selection.select2-selection--multiple',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_field_focus_color'             => [
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-email) input[type=email]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=password]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=search]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=tel]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=text]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=number]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) input[type=url]:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) textarea:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) select:focus',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-color',
					'class'  => 'body .wfacp_main_form .form-row:not(.woocommerce-invalid-required-field) .woocommerce-input-wrapper .select2-container .select2-selection--single:focus',
					'device' => 'desktop',
				],


			],
			$selected_template_slug . '_field_input_color'             => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=email]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=password]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=search]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=tel]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=text]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=url]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row textarea',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row select',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row .woocommerce-input-wrapper .select2-container .select2-selection--single',
					'device' => 'desktop',
				],

				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .form-row input[type=number]',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .select2-container .select2-selection--single .select2-selection__rendered',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-checkout select#join_referral_program',
					'device' => 'desktop',
				],


			],
			$selected_template_slug . '_field_border_width'            => [
				[
					'type'   => 'border-width',
					'class'  => 'body .wfacp_main_form .select2-container--default.select2-container--focus .select2-selection--multiple',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-width',
					'class'  => 'body .wfacp_main_form .select2-container--default .select2-selection--multiple',
					'device' => 'desktop',
				],
				[
					'type'   => 'border-width',
					'class'  => '#et-boc .et-l span.select2-selection.select2-selection--multiple',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_form_content_color'            => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form  .woocommerce-form-login-toggle .woocommerce-info',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form form.woocommerce-form.woocommerce-form-login.login p',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form label.woocommerce-form__label span',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form .wfacp_checkbox_field label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_checkbox_field span',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table td.product-name',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table .product-name',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table .product-name dl *',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table td.product-total',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tfoot tr th',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tfoot tr td',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tr.order-total th',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tr.order-total td',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form #shipping_calculator_field.wfacp_shipping_options label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .wfacp_shipping_table tr.shipping td p',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .wfacp-product-switch-title div',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-privacy-policy-text p',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .wfacp_shipping_options ul li p',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .shop_table .wfacp-product-switch-title div',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-info .message-container',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form #wc_checkout_add_ons .description',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form ol li',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form ul li',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form ul li label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .woocommerce-checkout-review-order h3',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .aw_addon_wrap label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => '.wfacp_shipping_table ul#shipping_method label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form table tr th',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form table tr td dl *',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form table tr td',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'table.shop_table.woocommerce-checkout-review-order-table thead tr th',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'device' => 'desktop',
					'class'  => 'body .wfacp-form table.shop_table tr.order-total td strong>span',
				],
				[
					'type'   => 'color',
					'device' => 'desktop',
					'class'  => 'body table.shop_table tr.order-total td strong>span>span',
				],
				[
					'type'   => 'color',
					'device' => 'desktop',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tr span.amount',
				],
				[
					'type'   => 'color',
					'device' => 'desktop',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tr span.woocommerce-Price-currencySymbol',
				],
				[
					'type'   => 'color',
					'device' => 'desktop',
					'class'  => 'body .wfacp-form table.shop_table.woocommerce-checkout-review-order-table tr span.amount bdi',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form ul li span',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form .wfacp_shipping_table ul li span',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form ul li',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .woocommerce-checkout #payment ul.payment_methods label',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .woocommerce-checkout #payment ul.payment_methods p',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_form_content_link_color'       => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form .woocommerce-form-login-toggle .woocommerce-info a.showlogin',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form p.lost_password a',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form #product_switching_field .wfacp_product_switcher_col_2 .wfacp_product_switcher_description a.wfacp_qv-button',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form a',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_woocommerce_form_coupon .wfacp-coupon-section .woocommerce-info .wfacp_showcoupon',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body #et-boc #wfacp-e-form .wfacp-form a',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_html_widget a',
					'device' => 'desktop',
				],
			],
			$selected_template_slug . '_form_content_link_hover_color' => [
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form .woocommerce-form-login-toggle .woocommerce-info a.showlogin:hover',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form p.lost_password a:hover',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_main_form #product_switching_field .wfacp_product_switcher_col_2 .wfacp_product_switcher_description a.wfacp_qv-button:hover',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp-form a:hover',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body .wfacp_woocommerce_form_coupon .wfacp-coupon-section .woocommerce-info .wfacp_showcoupon:hover',
					'device' => 'desktop',
				],
				[
					'type'   => 'color',
					'class'  => 'body #et-boc #wfacp-e-form .wfacp-form a:hover',
					'device' => 'desktop',
				],
			],
		];

		$custom_arr = [];
		$step_btns  = [ 'order-place' ];
		foreach ( $step_btns as $skey => $svalue ) {
			$btn_class_key = 'button';
			$st_id         = '#place_order';
			$classAdd      = '';
			$color_key     = $svalue;
			$custom_arr[]  = [
				$selected_template_slug . '_btn_' . $color_key . '_bg_color'         => [
					[
						'type'   => 'background-color',
						'class'  => 'body .wfacp_main_form .woocommerce-checkout .button.' . $btn_class_key . $st_id . $classAdd,
						'device' => 'desktop',
					],
					[
						'type'   => 'background-color',
						'class'  => 'body #wfacp_qr_model_wrap .wfacp_qr_wrap .button',
						'device' => 'desktop',
					],
				],
				$selected_template_slug . '_btn_' . $color_key . '_text_color'       => [
					[
						'type'   => 'color',
						'class'  => 'body .wfacp_main_form .woocommerce-checkout .button.' . $btn_class_key . $st_id . $classAdd,
						'device' => 'desktop',
					],
					[
						'type'   => 'color',
						'class'  => 'body  #wfacp_qr_model_wrap .wfacp_qr_wrap .button',
						'device' => 'desktop',
					],

				],
				$selected_template_slug . '_btn_' . $color_key . '_bg_hover_color'   => [
					[
						'type'   => 'background-color',
						'class'  => 'body .wfacp_main_form .woocommerce-checkout .button.' . $btn_class_key . $st_id . $classAdd . ':hover',
						'device' => 'desktop',
					],
					[
						'type'   => 'background-color',
						'class'  => 'body  #wfacp_qr_model_wrap .wfacp_qr_wrap .button:hover',
						'device' => 'desktop',
					],

				],
				$selected_template_slug . '_btn_' . $color_key . '_text_hover_color' => [
					[
						'type'   => 'color',
						'class'  => 'body .wfacp_main_form .woocommerce-checkout .button.' . $btn_class_key . $st_id . $classAdd . ':hover',
						'device' => 'desktop',
					],
					[
						'type'   => 'color',
						'class'  => 'body  #wfacp_qr_model_wrap .wfacp_qr_wrap .button:hover',
						'device' => 'desktop',
					],

				],
			];
		}

		foreach ( $custom_arr as $key => $value ) {
			if ( is_array( $value ) && count( $value ) > 0 ) {
				foreach ( $value as $key1 => $value1 ) {
					$section_data_keys['colors'][ $key1 ] = $value1;
				}
			}
		}

		return $section_data_keys;
	}

	public function remove_built_in_title_tag( $status ) {

		remove_action( 'wp_head', '_wp_render_title_tag', 1 );

		return $status;
	}
}